/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.domain;

import java.net.URI;
import javax.annotation.Nullable;

public class KeyPair {
    private final URI id;
    private final String name;
    private final boolean isDefault;
    @Nullable
    private final String privateKey;
    private final String fingerPrint;

    public KeyPair(URI id, String name, boolean isDefault, @Nullable String privateKey, String fingerPrint) {
        this.id = id;
        this.name = name;
        this.isDefault = isDefault;
        this.privateKey = privateKey;
        this.fingerPrint = fingerPrint;
    }

    public URI getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Nullable
    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fingerPrint == null ? 0 : this.fingerPrint.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.isDefault ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.privateKey == null ? 0 : this.privateKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyPair other = (KeyPair)obj;
        if (this.fingerPrint == null ? other.fingerPrint != null : !this.fingerPrint.equals(other.fingerPrint)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.isDefault != other.isDefault) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.privateKey == null ? other.privateKey != null : !this.privateKey.equals(other.privateKey));
    }

    public String toString() {
        return "Key [fingerPrint=" + this.fingerPrint + ", id=" + this.id + ", isDefault=" + this.isDefault + ", name=" + this.name + ", privateKey=" + (this.privateKey != null) + "]";
    }
}

