/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.domain;

import java.net.URI;

public class Node
implements Comparable<Node> {
    private final String name;
    private final URI id;
    private final String ipAddress;
    private final int port;
    private final boolean enabled;
    private final String description;

    public Node(String name, URI id, String ipAddress, int port, boolean enabled, String description) {
        this.name = name;
        this.id = id;
        this.ipAddress = ipAddress;
        this.port = port;
        this.enabled = enabled;
        this.description = description;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public URI getId() {
        return this.id;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    @Override
    public int compareTo(Node that) {
        return this == that ? 0 : this.getId().compareTo(that.getId());
    }

    public String toString() {
        return "Node [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", ipAddress=" + this.ipAddress + ", port=" + this.port + ", enabled=" + this.enabled + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.enabled ? 1231 : 1237);
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.port;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.port == other.port;
    }
}

