/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Utils;

@Singleton
public class ParseTerremarkVCloudErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final Pattern RESOURCE_PATTERN = Pattern.compile(".*/v[^/]+/([^/]+)/([0-9]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        void var3_9;
        HttpResponseException httpResponseException = new HttpResponseException(command, response);
        try {
            String content = this.parseErrorFromContentOrNull(command, response);
            switch (response.getStatusCode()) {
                case 400: {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(response.getMessage(), (Throwable)httpResponseException);
                    break;
                }
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException(command.getRequest(), content);
                    break;
                }
                case 403: 
                case 404: {
                    String path = command.getRequest().getEndpoint().getPath();
                    Matcher matcher = RESOURCE_PATTERN.matcher(path);
                    String message = matcher.find() ? String.format("%s %s not found", matcher.group(1), matcher.group(2)) : path;
                    ResourceNotFoundException resourceNotFoundException = new ResourceNotFoundException(message, (Throwable)httpResponseException);
                    break;
                }
                case 500: {
                    if (response.getMessage().indexOf("because there is a pending task running") == -1 && response.getMessage().indexOf("because it is already powered off") == -1 && response.getMessage().indexOf("already exists") == -1 && response.getMessage().indexOf("same name exists") == -1) break;
                    IllegalStateException illegalStateException = new IllegalStateException(response.getMessage(), (Throwable)httpResponseException);
                    break;
                }
                default: {
                    HttpResponseException httpResponseException2 = new HttpResponseException(command, response, content);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.releasePayload((HttpResponse)response);
            command.setException((Exception)httpResponseException);
            throw throwable;
        }
        HttpUtils.releasePayload((HttpResponse)response);
        command.setException((Exception)var3_9);
    }

    String parseErrorFromContentOrNull(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Utils.toStringAndClose((InputStream)response.getPayload().getInput());
            }
            catch (IOException e) {
                this.logger.warn((Throwable)e, "exception reading error from response", new Object[]{response});
            }
        }
        return null;
    }
}

