/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import java.net.URI;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.terremark.domain.InternetService;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class InternetServiceHandler
extends ParseSax.HandlerWithResult<InternetService> {
    @Resource
    protected Logger logger = Logger.NULL;
    private StringBuilder currentText = new StringBuilder();
    private boolean inPublicIpAddress;
    private URI location;
    private URI addressLocation;
    private String serviceName;
    private String address;
    private PublicIpAddress publicIpAddress;
    private int port;
    private String description;
    private int timeout;
    private boolean enabled;
    private Protocol protocol;

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    public InternetService getResult() {
        return new InternetService(this.serviceName, this.location, this.publicIpAddress, this.port, this.protocol, this.enabled, this.timeout, this.description);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("PublicIpAddress")) {
            this.inPublicIpAddress = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Href") && this.currentOrNull() != null) {
            if (this.inPublicIpAddress) {
                this.addressLocation = URI.create(this.currentOrNull());
            } else {
                this.location = URI.create(this.currentOrNull());
            }
        } else if (qName.equals("Name")) {
            if (this.inPublicIpAddress) {
                this.address = this.currentOrNull();
            } else {
                this.serviceName = this.currentOrNull();
            }
        } else if (qName.equals("PublicIpAddress")) {
            this.publicIpAddress = new PublicIpAddress(this.address, this.addressLocation);
            this.address = null;
            this.addressLocation = null;
            this.inPublicIpAddress = false;
        } else if (qName.equals("Port")) {
            this.port = Integer.parseInt(this.currentOrNull());
        } else if (qName.equals("Protocol")) {
            this.protocol = Protocol.valueOf(this.currentOrNull());
        } else if (qName.equals("Enabled")) {
            this.enabled = Boolean.parseBoolean(this.currentOrNull());
        } else if (qName.equals("Timeout")) {
            this.timeout = Integer.parseInt(this.currentOrNull());
        } else if (qName.equals("Description")) {
            this.description = this.currentOrNull();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

