/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import java.net.URI;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.terremark.domain.KeyPair;

public class KeyPairHandler
extends ParseSax.HandlerWithResult<KeyPair> {
    @Resource
    protected Logger logger = Logger.NULL;
    private StringBuilder currentText = new StringBuilder();
    private URI location;
    private String name;
    private boolean isDefault;
    private String privateKey;
    private String fingerPrint;

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    public KeyPair getResult() {
        return new KeyPair(this.location, this.name, this.isDefault, this.privateKey, this.fingerPrint);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Href") && this.currentOrNull() != null) {
            this.location = URI.create(this.currentOrNull());
        } else if (qName.equals("Name")) {
            this.name = this.currentOrNull();
        } else if (qName.equals("IsDefault")) {
            this.isDefault = Boolean.parseBoolean(this.currentOrNull());
        } else if (qName.equals("PrivateKey")) {
            this.privateKey = this.currentOrNull();
        } else if (qName.equals("FingerPrint")) {
            this.fingerPrint = this.currentOrNull();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

