/**
 *
 * Copyright (C) 2010 Cloud Conscious, LLC. <info@cloudconscious.com>
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */

package org.jclouds.vcloud.terremark.domain;

import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.network.internal.VCloudExpressOrgNetworkAdapter;
import org.jclouds.vcloud.terremark.domain.internal.TerremarkVCloudExpressNetwork;

/**
 * 
 * @author Adrian Cole
 */
public class TerremarkOrgNetwork extends VCloudExpressOrgNetworkAdapter {

   private final TerremarkVCloudExpressNetwork delegate;

   public TerremarkOrgNetwork(TerremarkVCloudExpressNetwork in) {
      super(in);
      this.delegate = in;
   }

   public ReferenceType getNetworkExtension() {
      return delegate.getNetworkExtension();
   }

   public ReferenceType getIps() {
      return delegate.getIps();
   }
}