/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.compute.ComputeServiceContextFactory;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.rest.RestContext;
import org.jclouds.ssh.jsch.config.JschSshClientModule;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressAsyncClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.domain.InternetService;
import org.jclouds.vcloud.terremark.domain.Node;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeGroups;
import org.testng.annotations.Test;

@Test(groups={"live"}, sequential=true, testName="vcloud.TerremarkVCloudClientLiveTest")
public class InternetServiceLiveTest {
    TerremarkVCloudExpressClient tmClient;
    private Set<InternetService> services = Sets.newLinkedHashSet();
    private RestContext<TerremarkVCloudExpressClient, TerremarkVCloudExpressAsyncClient> context;
    public static final String PREFIX = System.getProperty("user.name") + "-terremark";
    protected String provider = "trmk-vcloudexpress";
    protected String identity;
    protected String credential;
    protected String endpoint;
    protected String apiversion;

    @Test
    public void testGetAllInternetServices() throws Exception {
        this.tmClient.getAllInternetServicesInVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref());
    }

    private void delete(Set<InternetService> set) {
        HashSet publicIps = Sets.newHashSet();
        for (InternetService service : set) {
            for (Node node : this.tmClient.getNodes(service.getId())) {
                this.tmClient.deleteNode(node.getId());
            }
            this.tmClient.deleteInternetService(service.getId());
            publicIps.add(service.getPublicIpAddress().getId());
        }
        for (URI id : publicIps) {
            this.tmClient.deletePublicIp(id);
        }
    }

    @Test
    public void testGetAllPublicIps() throws Exception {
        for (PublicIpAddress ip : this.tmClient.getPublicIpsAssociatedWithVDC(this.tmClient.findVDCInOrgNamed(null, null).getHref())) {
            this.tmClient.getInternetServicesOnPublicIp(ip.getId());
        }
    }

    @AfterTest
    void cleanup() throws InterruptedException, ExecutionException, TimeoutException {
        this.delete(this.services);
    }

    protected void setupCredentials() {
        this.identity = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".identity"), (Object)("test." + this.provider + ".identity"));
        this.credential = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".credential"), (Object)("test." + this.provider + ".credential"));
        this.endpoint = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".endpoint"), (Object)("test." + this.provider + ".endpoint"));
        this.apiversion = (String)Preconditions.checkNotNull((Object)System.getProperty("test." + this.provider + ".apiversion"), (Object)("test." + this.provider + ".apiversion"));
    }

    protected Properties setupProperties() {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.trust-all-certs", "true");
        overrides.setProperty("jclouds.relax-hostname", "true");
        overrides.setProperty(this.provider + ".identity", this.identity);
        overrides.setProperty(this.provider + ".credential", this.credential);
        overrides.setProperty(this.provider + ".endpoint", this.endpoint);
        overrides.setProperty(this.provider + ".apiversion", this.apiversion);
        return overrides;
    }

    @BeforeGroups(groups={"live"})
    public void setupClient() {
        this.setupCredentials();
        Properties overrides = this.setupProperties();
        this.context = new ComputeServiceContextFactory().createContext(this.provider, (Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new JschSshClientModule()), overrides).getProviderSpecificContext();
        this.tmClient = (TerremarkVCloudExpressClient)this.context.getApi();
    }

    void print(Set<InternetService> set) {
        for (InternetService service : set) {
            System.out.printf("%d (%s:%d%n)", service.getName(), service.getPublicIpAddress().getAddress(), service.getPort());
            for (Node node : this.tmClient.getNodes(service.getId())) {
                System.out.printf("   %d (%s:%d%n)", node.getName(), node.getIpAddress(), node.getPort());
            }
        }
    }
}

