/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import domain.VCloudVersionsAsyncClient;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.RestClientTest;
import org.jclouds.rest.RestContextFactory;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.util.Utils;
import org.jclouds.vcloud.CommonVCloudClient;
import org.jclouds.vcloud.VCloudExpressAsyncClientTest;
import org.jclouds.vcloud.config.CommonVCloudRestClientModule;
import org.jclouds.vcloud.domain.AllocationModel;
import org.jclouds.vcloud.domain.Capacity;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.VDCStatus;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.network.NetworkConfig;
import org.jclouds.vcloud.filters.SetVCloudTokenCookie;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressAsyncClient;
import org.jclouds.vcloud.terremark.config.TerremarkRestClientModule;
import org.jclouds.vcloud.terremark.config.TerremarkVCloudExpressRestClientModule;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.internal.TerremarkOrgImpl;
import org.jclouds.vcloud.terremark.domain.internal.TerremarkVDCImpl;
import org.jclouds.vcloud.terremark.options.AddInternetServiceOptions;
import org.jclouds.vcloud.terremark.options.AddNodeOptions;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;
import org.jclouds.vcloud.terremark.xml.CustomizationParametersHandler;
import org.jclouds.vcloud.terremark.xml.InternetServiceHandler;
import org.jclouds.vcloud.terremark.xml.InternetServicesHandler;
import org.jclouds.vcloud.terremark.xml.KeyPairByNameHandler;
import org.jclouds.vcloud.terremark.xml.KeyPairHandler;
import org.jclouds.vcloud.terremark.xml.KeyPairsHandler;
import org.jclouds.vcloud.terremark.xml.NodeHandler;
import org.jclouds.vcloud.terremark.xml.NodesHandler;
import org.jclouds.vcloud.terremark.xml.TerremarkCatalogItemHandler;
import org.jclouds.vcloud.terremark.xml.TerremarkVDCHandler;
import org.jclouds.vcloud.xml.CatalogHandler;
import org.jclouds.vcloud.xml.VCloudExpressVAppHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, sequential=true, testName="TerremarkVCloudExpressAsyncClientTest")
public class TerremarkVCloudExpressAsyncClientTest
extends RestClientTest<TerremarkVCloudExpressAsyncClient> {
    public void testCatalogItemURI() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getCatalogItem", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TerremarkCatalogItemHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindCatalogItemInOrgCatalogNamed() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("findCatalogItemInOrgCatalogNamed", String.class, String.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{"org", "catalog", "item"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalogItem/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TerremarkCatalogItemHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalog() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getCatalog", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://catalog")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://catalog HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalog+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetVDC() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getVDC", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/vdc/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TerremarkVDCHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testInstantiateVAppTemplateInVDCURI() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("instantiateVAppTemplateInVDC", URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), URI.create("https://vcloud/vAppTemplate/3"), "name"});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/InstantiateVAppTemplateParams-test.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressVAppHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testInstantiateVAppTemplateInVDCURIOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("instantiateVAppTemplateInVDC", URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), URI.create("https://vcloud/vAppTemplate/3"), "name", TerremarkInstantiateVAppTemplateOptions.Builder.processorCount((int)2).memory(512L).inGroup("group").withPassword("password").inRow("row").addNetworkConfig(new NetworkConfig(URI.create("http://network")))});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/InstantiateVAppTemplateParams-options-test.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VCloudExpressVAppHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("addInternetServiceToVDC", URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), "name", Protocol.TCP, 22});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/internetServices/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateInternetService-test2.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("addInternetServiceToVDC", URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), "name", Protocol.TCP, 22, AddInternetServiceOptions.Builder.disabled().withDescription("yahoo")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/internetServices/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateInternetService-options-test.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetAllInternetServices() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getAllInternetServicesInVDC", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/internetServices/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetServicesList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServicesHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getInternetService", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/internetService/12")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/internetService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetServicesList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("deleteInternetService", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/internetService/12")});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/internetService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceToExistingIp() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("addInternetServiceToExistingIp", URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/publicIp/12"), "name", Protocol.TCP, 22});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/publicIp/12/internetServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateInternetService-test2.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceToExistingIpOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("addInternetServiceToExistingIp", URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/publicIp/12"), "name", Protocol.TCP, 22, AddInternetServiceOptions.Builder.disabled().withDescription("yahoo")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/publicIp/12/internetServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateInternetService-options-test.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddNode() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("addNode", URI.class, String.class, String.class, Integer.TYPE, AddNodeOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/internetService/12"), "10.2.2.2", "name", 22});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateNodeService-test2.xml")), "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddNodeOptions() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("addNode", URI.class, String.class, String.class, Integer.TYPE, AddNodeOptions[].class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/internetService/12"), "10.2.2.2", "name", 22, AddNodeOptions.Builder.disabled().withDescription("yahoo")});
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateNodeService-options-test.xml")), "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetKeyPairInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("findKeyPairInOrg", URI.class, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1"), "keyPair"});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vcloudExpress.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairByNameHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfigureNodeWithDescription() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("configureNode", URI.class, String.class, Boolean.TYPE, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/nodeService/12"), "name", true, "eggs"});
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>name</Name><Enabled>true</Enabled><Description>eggs</Description></NodeService>", "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfigureNodeNoDescription() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("configureNode", URI.class, String.class, Boolean.TYPE, String.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/nodeService/12"), "name", true, null});
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>name</Name><Enabled>true</Enabled></NodeService>", "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetNodes() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getNodes", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/internetService/12")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodesHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteNode() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("deleteNode", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/nodeService/12")});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetCustomizationOptionsOfCatalogItem() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getCustomizationOptions", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/template/12/options/customization")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/template/12/options/customization HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.catalogItemCustomizationParameters+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CustomizationParametersHandler.class);
        this.assertExceptionParserClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListKeyPairsInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("listKeyPairsInOrg", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vcloudExpress.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairsHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListKeyPairsInOrgNull() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("listKeyPairsInOrg", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{null});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vcloudExpress.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairsHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnEmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testListKeyPairsInOrgNotFound() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("listKeyPairsInOrg", URI.class);
        this.processor.createRequest(method, new Object[]{URI.create("d")});
    }

    public void testGetNode() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getNode", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/nodeService/12")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetKeyPair() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("getKeyPair", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/key/12")});
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/key/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairHandler.class);
        this.assertExceptionParserClassEquals(method, ReturnNullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteKeyPair() throws SecurityException, NoSuchMethodException, IOException {
        Method method = TerremarkVCloudExpressAsyncClient.class.getMethod("deleteKeyPair", URI.class);
        GeneratedHttpRequest request = this.processor.createRequest(method, new Object[]{URI.create("https://vcloud/extensions/key/12")});
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/key/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, (HttpRequest)request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertExceptionParserClassEquals(method, ReturnVoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SetVCloudTokenCookie.class);
    }

    protected TypeLiteral<RestAnnotationProcessor<TerremarkVCloudExpressAsyncClient>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<TerremarkVCloudExpressAsyncClient>>(){};
    }

    protected Module createModule() {
        return new TerremarkVCloudRestClientModuleExtension();
    }

    public RestContextSpec<?, ?> createContextSpec() {
        return new RestContextFactory().createContextSpec("trmk-vcloudexpress", "identity", "credential", new Properties());
    }

    @RequiresHttp
    @ConfiguresRestClient
    protected static class TerremarkVCloudRestClientModuleExtension
    extends TerremarkVCloudExpressRestClientModule {
        protected TerremarkVCloudRestClientModuleExtension() {
        }

        protected URI provideAuthenticationURI(VCloudVersionsAsyncClient versionService, @Named(value="jclouds.api-version") String version) {
            return URI.create("https://vcloud/login");
        }

        protected void configure() {
            super.configure();
            this.bind(TerremarkRestClientModule.OrgNameToKeysListSupplier.class).to(TestOrgNameToKeysListSupplier.class);
            this.bind(CommonVCloudRestClientModule.OrgMapSupplier.class).to(TestTerremarkOrgMapSupplier.class);
            this.bind(CommonVCloudRestClientModule.OrgCatalogSupplier.class).to(VCloudExpressAsyncClientTest.VCloudRestClientModuleExtension.TestOrgCatalogSupplier.class);
            this.bind(CommonVCloudRestClientModule.OrgCatalogItemSupplier.class).to(VCloudExpressAsyncClientTest.VCloudRestClientModuleExtension.TestOrgCatalogItemSupplier.class);
            this.bind(CommonVCloudRestClientModule.OrgVDCSupplier.class).to(TestTerremarkOrgVDCSupplier.class);
        }

        protected URI provideOrg(@org.jclouds.vcloud.endpoints.Org Iterable<ReferenceType> orgs) {
            return URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1");
        }

        protected String provideOrgName(@org.jclouds.vcloud.endpoints.Org Iterable<ReferenceType> orgs) {
            return "org";
        }

        protected URI provideCatalog(Org org, @Named(value="jclouds.identity") String user) {
            return URI.create("https://catalog");
        }

        protected Org provideOrg(CommonVCloudClient discovery) {
            return null;
        }

        protected Iterable<ReferenceType> provideOrgs(Supplier<VCloudSession> cache, @Named(value="jclouds.identity") String user) {
            return null;
        }

        protected URI provideDefaultTasksList(Org org) {
            return URI.create("https://taskslist");
        }

        protected URI provideDefaultVDC(Org org, @org.jclouds.vcloud.endpoints.VDC String defaultVDC) {
            return URI.create("https://vdc/1");
        }

        protected String provideDefaultVDCName(@org.jclouds.vcloud.endpoints.VDC Supplier<Map<String, String>> vDCtoOrgSupplier) {
            return "vdc";
        }

        protected String provideCatalogName(Supplier<Map<String, Map<String, ? extends Catalog>>> catalogs) {
            return "catalog";
        }

        protected URI provideDefaultNetwork(URI vdc, Injector injector) {
            return URI.create("https://vcloud.safesecureweb.com/network/1990");
        }

        @Singleton
        public static class TestTerremarkOrgVDCSupplier
        extends CommonVCloudRestClientModule.OrgVDCSupplier {
            @Inject
            protected TestTerremarkOrgVDCSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, ? extends VDC>> get() {
                return ImmutableMap.of((Object)"org", (Object)ImmutableMap.of((Object)"vdc", (Object)new TerremarkVDCImpl("vdc", null, URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), VDCStatus.READY, null, "description", (Iterable)ImmutableSet.of(), AllocationModel.UNRECOGNIZED, new Capacity("MB", 0L, 0L, 0, 0L), new Capacity("MB", 0L, 0L, 0, 0L), new Capacity("MB", 0L, 0L, 0, 0L), (Map)ImmutableMap.of((Object)"vapp", (Object)new ReferenceTypeImpl("vapp", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/188849-1")), (Object)"network", (Object)new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdcItem/2"))), (Map)ImmutableMap.of(), 0, 0, 0, false, (ReferenceType)new ReferenceTypeImpl("catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1")), (ReferenceType)new ReferenceTypeImpl("publicIps", "application/vnd.tmrk.vCloud.publicIpsList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/publicIps/1")), (ReferenceType)new ReferenceTypeImpl("internetServices", "application/vnd.tmrk.vCloud.internetServicesList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/internetServices/1")))));
            }
        }

        @Singleton
        public static class TestTerremarkOrgMapSupplier
        extends CommonVCloudRestClientModule.OrgMapSupplier {
            @Inject
            protected TestTerremarkOrgMapSupplier() {
                super(null, null);
            }

            public Map<String, Org> get() {
                return ImmutableMap.of((Object)"org", (Object)new TerremarkOrgImpl("org", null, URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1"), null, (Map)ImmutableMap.of((Object)"catalog", (Object)new ReferenceTypeImpl("catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1"))), (Map)ImmutableMap.of((Object)"vdc", (Object)new ReferenceTypeImpl("vdc", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"))), (Map)ImmutableMap.of(), (ReferenceType)new ReferenceTypeImpl("tasksList", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/tasksList/1")), (ReferenceType)new ReferenceTypeImpl("keysList", "application/vnd.tmrk.vcloudExpress.keysList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/keysList/1"))));
            }
        }

        @Singleton
        public static class TestOrgNameToKeysListSupplier
        extends TerremarkRestClientModule.OrgNameToKeysListSupplier {
            @Inject
            protected TestOrgNameToKeysListSupplier(Supplier<VCloudSession> sessionSupplier) {
                super(sessionSupplier, null);
            }

            public Map<String, ReferenceType> get() {
                return Maps.transformValues((Map)((VCloudSession)this.sessionSupplier.get()).getOrgs(), (Function)new Function<ReferenceType, ReferenceType>(){

                    public ReferenceType apply(ReferenceType from) {
                        return new ReferenceTypeImpl(from.getName(), "application/vnd.tmrk.vcloudExpress.keysList+xml", URI.create(from.getHref().toASCIIString() + "/keysList"));
                    }
                });
            }
        }
    }
}

