/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.jclouds.net.IPSocket;
import org.jclouds.ssh.SshClient;
import org.jclouds.vcloud.terremark.TerremarkClientLiveTest;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressClient;
import org.jclouds.vcloud.terremark.domain.KeyPair;
import org.jclouds.vcloud.terremark.domain.TerremarkOrg;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.Test;

@Test(groups={"live"}, sequential=true, testName="vcloud.TerremarkVCloudClientLiveTest")
public class TerremarkVCloudExpressClientLiveTest
extends TerremarkClientLiveTest {
    KeyPair key;

    @Test
    public void testKeysList() throws Exception {
        TerremarkVCloudExpressClient vCloudExpressClient = (TerremarkVCloudExpressClient)TerremarkVCloudExpressClient.class.cast(this.tmClient);
        TerremarkOrg org = vCloudExpressClient.findOrgNamed(null);
        Set response = vCloudExpressClient.listKeyPairsInOrg(null);
        Assert.assertNotNull((Object)response);
        System.err.println(response);
        Assert.assertEquals((Collection)response, (Collection)vCloudExpressClient.listKeyPairsInOrg(org.getHref()));
    }

    @Override
    protected void prepare() {
        TerremarkVCloudExpressClient vCloudExpressClient = (TerremarkVCloudExpressClient)TerremarkVCloudExpressClient.class.cast(this.tmClient);
        TerremarkOrg org = vCloudExpressClient.findOrgNamed(null);
        try {
            this.key = vCloudExpressClient.generateKeyPairInOrg(org.getHref(), "livetest", false);
        }
        catch (IllegalStateException e) {
            this.key = vCloudExpressClient.findKeyPairInOrg(org.getHref(), "livetest");
            vCloudExpressClient.deleteKeyPair(this.key.getId());
            this.key = vCloudExpressClient.generateKeyPairInOrg(org.getHref(), "livetest", false);
        }
        Assert.assertNotNull((Object)this.key);
        System.err.println(this.key);
        Assert.assertEquals((String)this.key.getName(), (String)"livetest");
        Assert.assertNotNull((Object)this.key.getPrivateKey());
        Assert.assertNotNull((Object)this.key.getFingerPrint());
        Assert.assertEquals((boolean)this.key.isDefault(), (boolean)false);
        Assert.assertEquals((String)this.key.getFingerPrint(), (String)vCloudExpressClient.findKeyPairInOrg(org.getHref(), this.key.getName()).getFingerPrint());
    }

    @AfterTest
    void cleanup1() throws InterruptedException, ExecutionException, TimeoutException {
        if (this.key != null) {
            TerremarkVCloudExpressClient vCloudExpressClient = (TerremarkVCloudExpressClient)TerremarkVCloudExpressClient.class.cast(this.tmClient);
            vCloudExpressClient.deleteKeyPair(this.key.getId());
        }
    }

    @Override
    protected SshClient getConnectionFor(IPSocket socket) {
        return this.sshFactory.create(socket, "vcloud", this.key.getPrivateKey().getBytes());
    }

    @Override
    protected TerremarkInstantiateVAppTemplateOptions createInstantiateOptions() {
        return TerremarkInstantiateVAppTemplateOptions.Builder.processorCount((int)1).memory(512L).sshKeyFingerprint(this.key.getFingerPrint());
    }
}

