/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.easymock.classextension.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressPropertiesBuilder;
import org.jclouds.vcloud.terremark.binders.BindNodeConfigurationToXmlPayload;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.BindNodeConfigurationToXmlPayloadTest")
public class BindNodeConfigurationToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            Properties props = new Properties();
            Names.bindProperties((Binder)this.binder(), (Properties)((Properties)Preconditions.checkNotNull((Object)new TerremarkVCloudExpressPropertiesBuilder(props).build(), (Object)"properties")));
        }
    }});

    public void testChangeDescription() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>true</Enabled><Description>description</Description></NodeService>";
        this.assertConfigMakesPayload((Map<String, String>)ImmutableMap.of((Object)"name", (Object)"willie", (Object)"enabled", (Object)"true", (Object)"description", (Object)"description"), expectedPayload);
    }

    public void testDisableTraffic() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>false</Enabled></NodeService>";
        this.assertConfigMakesPayload((Map<String, String>)ImmutableMap.of((Object)"name", (Object)"willie", (Object)"enabled", (Object)"false"), expectedPayload);
    }

    public void testTwoOptions() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>true</Enabled></NodeService>";
        this.assertConfigMakesPayload((Map<String, String>)ImmutableMap.of((Object)"name", (Object)"willie", (Object)"enabled", (Object)"true"), expectedPayload);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNoOptions() throws IOException {
        String expectedPayload = "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>willie</Name><Enabled>false</Enabled></NodeService>";
        this.assertConfigMakesPayload((Map<String, String>)ImmutableMap.of(), expectedPayload);
    }

    private void assertConfigMakesPayload(Map<String, String> config, String expectedPayload) {
        BindNodeConfigurationToXmlPayload binder = (BindNodeConfigurationToXmlPayload)this.injector.getInstance(BindNodeConfigurationToXmlPayload.class);
        HttpRequest request = (HttpRequest)EasyMock.createMock(HttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        request.setPayload(expectedPayload);
        EasyMock.replay((Object[])new Object[]{request});
        binder.bindToRequest(request, config);
        EasyMock.verify((Object[])new Object[]{request});
    }
}

