/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.easymock.classextension.EasyMock;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Utils;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.internal.VCloudExpressVAppImpl;
import org.jclouds.vcloud.domain.ovf.ResourceAllocation;
import org.jclouds.vcloud.domain.ovf.ResourceType;
import org.jclouds.vcloud.terremark.TerremarkVCloudExpressPropertiesBuilder;
import org.jclouds.vcloud.terremark.binders.BindVAppConfigurationToXmlPayload;
import org.jclouds.vcloud.terremark.domain.VAppConfiguration;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.BindVAppConfigurationToXmlPayloadTest")
public class BindVAppConfigurationToXmlPayloadTest {
    Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            Properties props = new Properties();
            Names.bindProperties((Binder)this.binder(), (Properties)((Properties)Preconditions.checkNotNull((Object)new TerremarkVCloudExpressPropertiesBuilder(props).build(), (Object)"properties")));
        }
    }});

    public void testChangeName() throws IOException {
        VCloudExpressVAppImpl vApp = new VCloudExpressVAppImpl("MyAppServer6", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)new ResourceAllocation(1, "n/a", null, ResourceType.PROCESSOR, null, null, null, null, null, null, 2L, null), (Object)new ResourceAllocation(2, "n/a", null, ResourceType.MEMORY, null, null, null, null, null, null, 1024L, null), (Object)new ResourceAllocation(9, "n/a", null, ResourceType.DISK_DRIVE, null, "1048576", null, Integer.valueOf(0), null, null, 209152L, null)));
        String expected = Utils.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/terremark/configureVApp.xml")).replace("eduardo", "roberto");
        VAppConfiguration config = new VAppConfiguration().changeNameTo("roberto");
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)new Object[]{vApp, config}).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }

    public void testRemoveDisk() throws IOException {
        VCloudExpressVAppImpl vApp = new VCloudExpressVAppImpl("MyAppServer6", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)new ResourceAllocation(1, "n/a", null, ResourceType.PROCESSOR, null, null, null, null, null, null, 2L, null), (Object)new ResourceAllocation(2, "n/a", null, ResourceType.MEMORY, null, null, null, null, null, null, 1024L, null), (Object)new ResourceAllocation(9, "n/a", null, ResourceType.DISK_DRIVE, null, "1048576", null, Integer.valueOf(0), null, null, 209152L, null), (Object)new ResourceAllocation(9, "n/a", null, ResourceType.DISK_DRIVE, null, "1048576", null, Integer.valueOf(1), null, null, 209152L, null)));
        String expected = Utils.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/terremark/configureVApp.xml")).replace("eduardo", "MyAppServer6");
        VAppConfiguration config = new VAppConfiguration().deleteDiskWithAddressOnParent(1);
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)new Object[]{vApp, config}).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }

    public void testChangeCPUCountTo4() throws IOException {
        VCloudExpressVAppImpl vApp = new VCloudExpressVAppImpl("eduardo", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)new ResourceAllocation(1, "n/a", null, ResourceType.PROCESSOR, null, null, null, null, null, null, 4L, null), (Object)new ResourceAllocation(2, "n/a", null, ResourceType.MEMORY, null, null, null, null, null, null, 1024L, null), (Object)new ResourceAllocation(9, "n/a", null, ResourceType.DISK_DRIVE, null, "1048576", null, Integer.valueOf(0), null, null, 209152L, null)));
        String expected = Utils.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/terremark/configureVApp4.xml"));
        VAppConfiguration config = new VAppConfiguration().changeProcessorCountTo(4);
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)new Object[]{vApp, config}).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }

    public void testChangeMemoryTo1536() throws IOException {
        VCloudExpressVAppImpl vApp = new VCloudExpressVAppImpl("MyAppServer6", URI.create("https://services.vcloudexpress/terremark.com/api/v0.8/vapp/4213"), Status.OFF, Long.valueOf(0x400000L), null, (ListMultimap)ImmutableListMultimap.of(), null, null, null, (Set)ImmutableSet.of((Object)new ResourceAllocation(1, "n/a", null, ResourceType.PROCESSOR, null, null, null, null, null, null, 2L, null), (Object)new ResourceAllocation(2, "n/a", null, ResourceType.MEMORY, null, null, null, null, null, null, 1536L, null), (Object)new ResourceAllocation(9, "n/a", null, ResourceType.DISK_DRIVE, null, "1048576", null, Integer.valueOf(0), null, null, 209152L, null)));
        String expected = Utils.toStringAndClose((InputStream)this.getClass().getResourceAsStream("/terremark/configureVApp.xml")).replace("eduardo", "MyAppServer6").replace("1024", "1536");
        VAppConfiguration config = new VAppConfiguration().changeMemoryTo(1536L);
        GeneratedHttpRequest request = (GeneratedHttpRequest)EasyMock.createMock(GeneratedHttpRequest.class);
        org.easymock.EasyMock.expect((Object)request.getEndpoint()).andReturn((Object)URI.create("http://localhost/key")).anyTimes();
        org.easymock.EasyMock.expect((Object)request.getArgs()).andReturn((Object)new Object[]{vApp, config}).atLeastOnce();
        request.setPayload(expected);
        EasyMock.replay((Object[])new Object[]{request});
        BindVAppConfigurationToXmlPayload binder = (BindVAppConfigurationToXmlPayload)this.injector.getInstance(BindVAppConfigurationToXmlPayload.class);
        HashMap map = Maps.newHashMap();
        binder.bindToRequest((HttpRequest)request, (Map)map);
        EasyMock.verify((Object[])new Object[]{request});
    }
}

