/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute;

import com.google.common.base.Predicate;
import java.io.IOException;
import org.jclouds.compute.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="terremark.TerremarkECloudTemplateBuilderLiveTest")
public class TerremarkECloudTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public TerremarkECloudTemplateBuilderLiveTest() {
        this.provider = "trmk-ecloud";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                return input.family == OsFamily.RHEL || input.family == OsFamily.CENTOS && !input.version.equals("5.5") || input.family == OsFamily.UBUNTU && !input.version.equals("10.04") && !input.version.equals("8.04") || input.family == OsFamily.WINDOWS && (input.version.equals("2008 SP2") || input.version.equals("2008 R2"));
            }
        };
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = this.context.getComputeService().templateBuilder().build();
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"5.5");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.CENTOS);
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }
}

