/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute;

import java.io.IOException;
import org.jclouds.vcloud.terremark.compute.options.TerremarkVCloudTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TerremarkVCloudTemplateOptionsTest {
    public void testAs() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        Assert.assertEquals((Object)options.as(TerremarkVCloudTemplateOptions.class), (Object)options);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testkeyPairBadFormat() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.sshKeyFingerprint("");
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testkeyPairAndNoKeyPair() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.sshKeyFingerprint("mykeypair");
        options.noKeyPair();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testNoKeyPairAndKeyPair() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.noKeyPair();
        options.sshKeyFingerprint("mykeypair");
    }

    @Test
    public void testkeyPair() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.sshKeyFingerprint("mykeypair");
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)"mykeypair");
    }

    @Test
    public void testNullkeyPair() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        Assert.assertEquals((String)options.getSshKeyFingerprint(), null);
    }

    @Test
    public void testkeyPairStatic() {
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.sshKeyFingerprint((String)"mykeypair");
        Assert.assertEquals((String)options.getSshKeyFingerprint(), (String)"mykeypair");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testkeyPairNPE() {
        TerremarkVCloudTemplateOptions.Builder.sshKeyFingerprint(null);
    }

    @Test
    public void testnoKeyPair() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.noKeyPair();
        Assert.assertEquals((String)options.getSshKeyFingerprint(), null);
        assert (!options.shouldAutomaticallyCreateKeyPair());
    }

    @Test
    public void testFalsenoKeyPair() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        Assert.assertEquals((String)options.getSshKeyFingerprint(), null);
        assert (options.shouldAutomaticallyCreateKeyPair());
    }

    @Test
    public void testnoKeyPairStatic() {
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.noKeyPair();
        Assert.assertEquals((String)options.getSshKeyFingerprint(), null);
        assert (!options.shouldAutomaticallyCreateKeyPair());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinstallPrivateKeyBadFormat() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.installPrivateKey("whompy");
    }

    @Test
    public void testinstallPrivateKey() throws IOException {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.installPrivateKey("-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test
    public void testNullinstallPrivateKey() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        Assert.assertEquals((String)options.getPrivateKey(), null);
    }

    @Test
    public void testinstallPrivateKeyStatic() throws IOException {
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.installPrivateKey((String)"-----BEGIN RSA PRIVATE KEY-----");
        Assert.assertEquals((String)options.getPrivateKey(), (String)"-----BEGIN RSA PRIVATE KEY-----");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testinstallPrivateKeyNPE() {
        TerremarkVCloudTemplateOptions.Builder.installPrivateKey(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testauthorizePublicKeyBadFormat() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.authorizePublicKey("whompy");
    }

    @Test
    public void testauthorizePublicKey() throws IOException {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.authorizePublicKey("ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test
    public void testNullauthorizePublicKey() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        Assert.assertEquals((String)options.getPublicKey(), null);
    }

    @Test
    public void testauthorizePublicKeyStatic() throws IOException {
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.authorizePublicKey((String)"ssh-rsa");
        Assert.assertEquals((String)options.getPublicKey(), (String)"ssh-rsa");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testauthorizePublicKeyNPE() {
        TerremarkVCloudTemplateOptions.Builder.authorizePublicKey(null);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testblockOnPortBadFormat() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.blockOnPort(-1, -1);
    }

    @Test
    public void testblockOnPort() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.blockOnPort(22, 30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test
    public void testNullblockOnPort() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        Assert.assertEquals((int)options.getPort(), (int)-1);
        Assert.assertEquals((int)options.getSeconds(), (int)-1);
    }

    @Test
    public void testblockOnPortStatic() {
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.blockOnPort((int)22, (int)30);
        Assert.assertEquals((int)options.getPort(), (int)22);
        Assert.assertEquals((int)options.getSeconds(), (int)30);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testinboundPortsBadFormat() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.inboundPorts(new int[]{-1, -1});
    }

    @Test
    public void testinboundPorts() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        options.inboundPorts(new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }

    @Test
    public void testDefaultOpen22() {
        TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
    }

    @Test
    public void testinboundPortsStatic() {
        TerremarkVCloudTemplateOptions options = TerremarkVCloudTemplateOptions.Builder.inboundPorts((int[])new int[]{22, 30});
        Assert.assertEquals((int)options.getInboundPorts()[0], (int)22);
        Assert.assertEquals((int)options.getInboundPorts()[1], (int)30);
    }
}

