/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.terremark.TerremarkVCloudPropertiesBuilder;
import org.jclouds.vcloud.terremark.domain.TerremarkOrg;
import org.jclouds.vcloud.terremark.xml.TerremarkOrgHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.TerremarkOrgHandlerTest")
public class TerremarkOrgHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            public void configure() {
                super.configure();
                Properties props = new Properties();
                Names.bindProperties((Binder)this.binder(), (Properties)((Properties)Preconditions.checkNotNull((Object)new TerremarkVCloudPropertiesBuilder(props).build(), (Object)"properties")));
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/terremark/org.xml");
        TerremarkOrg result = (TerremarkOrg)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TerremarkOrgHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"adrian@jclouds.org");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/org/48"));
        Assert.assertEquals((Object)result.getCatalogs(), (Object)ImmutableMap.of((Object)"Miami Environment 1 Catalog", (Object)new ReferenceTypeImpl("Miami Environment 1 Catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32/catalog"))));
        Assert.assertEquals((Object)result.getVDCs(), (Object)ImmutableMap.of((Object)"Miami Environment 1", (Object)new ReferenceTypeImpl("Miami Environment 1", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32"))));
        Assert.assertEquals((Object)result.getTasksList(), (Object)new ReferenceTypeImpl("Miami Environment 1 Tasks List", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/vdc/32/tasksList")));
        Assert.assertEquals((Object)result.getKeysList(), (Object)new ReferenceTypeImpl("Keys", "application/vnd.tmrk.vcloudExpress.keysList+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8a-ext1.6/extensions/org/48/keys")));
    }
}

