/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.network.FenceMode;
import org.jclouds.vcloud.domain.network.VCloudExpressNetwork;
import org.jclouds.vcloud.terremark.domain.internal.TerremarkVCloudExpressNetwork;
import org.jclouds.vcloud.terremark.xml.TerremarkVCloudExpressNetworkHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="terremark.TerremarkVCloudExpressNetworkHandlerTest")
public class TerremarkVCloudExpressNetworkHandlerTest {
    private Injector injector;
    private ParseSax.Factory factory;

    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/express/network-terremark.xml");
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        VCloudExpressNetwork result = (VCloudExpressNetwork)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TerremarkVCloudExpressNetworkHandler.class)).parse(is);
        Assert.assertEquals((Object)result, (Object)new TerremarkVCloudExpressNetwork("10.122.209.128/28", "application/vnd.vmware.vcloud.network+xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/network/40031"), null, (Set)ImmutableSet.of(), "10.122.209.129", "255.255.255.240", (Set)ImmutableSet.of((Object)FenceMode.ISOLATED), null, (Set)ImmutableSet.of(), (Set)ImmutableSet.of(), (ReferenceType)new ReferenceTypeImpl("10.122.209.128/28", "application/xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/extensions/network/40031")), (ReferenceType)new ReferenceTypeImpl("IP Addresses", "application/xml", URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.5/extensions/network/40031/ips"))));
    }
}

