/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.terremark.domain.TerremarkVDC;
import org.jclouds.vcloud.terremark.xml.TerremarkVDCHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="vcloud.TerremarkVDCHandlerTest")
public class TerremarkVDCHandlerTest {
    public void testApplyInputStream() {
        InputStream is = this.getClass().getResourceAsStream("/terremark/vdc.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        TerremarkVDC result = (TerremarkVDC)factory.create((ParseSax.HandlerWithResult)injector.getInstance(TerremarkVDCHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"Miami Environment 1");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32"));
        Assert.assertEquals((Object)result.getResourceEntities(), (Object)ImmutableMap.of((Object)"adriantest", (Object)new ReferenceTypeImpl("adriantest", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/15124")), (Object)"centos-53", (Object)new ReferenceTypeImpl("centos-53", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/15120"))));
        Assert.assertEquals((Object)result.getAvailableNetworks(), (Object)ImmutableMap.of((Object)"10.114.34.128/26", (Object)new ReferenceTypeImpl("10.114.34.128/26", "application/vnd.vmware.vcloud.network+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/network/1708"))));
        Assert.assertEquals((Object)result.getCatalog(), (Object)new ReferenceTypeImpl("Miami Environment 1", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32/catalog")));
        Assert.assertEquals((Object)result.getPublicIps(), (Object)new ReferenceTypeImpl("Public IPs", "application/xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32/publicIps")));
        Assert.assertEquals((Object)result.getInternetServices(), (Object)new ReferenceTypeImpl("Internet Services", "application/xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32/internetServices")));
    }
}

