/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.MapPayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.vcloud.filters.SetVCloudTokenCookie;
import org.jclouds.vcloud.functions.OrgNameVDCNameResourceEntityNameToEndpoint;
import org.jclouds.vcloud.terremark.TerremarkVCloudAsyncClient;
import org.jclouds.vcloud.terremark.binders.BindCreateKeyToXmlPayload;
import org.jclouds.vcloud.terremark.domain.InternetService;
import org.jclouds.vcloud.terremark.domain.KeyPair;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;
import org.jclouds.vcloud.terremark.domain.TerremarkNetwork;
import org.jclouds.vcloud.terremark.domain.TerremarkOrgNetwork;
import org.jclouds.vcloud.terremark.functions.OrgURIToKeysListEndpoint;
import org.jclouds.vcloud.terremark.functions.VDCURIToInternetServicesEndpoint;
import org.jclouds.vcloud.terremark.functions.VDCURIToPublicIPsEndpoint;
import org.jclouds.vcloud.terremark.options.AddInternetServiceOptions;
import org.jclouds.vcloud.terremark.xml.InternetServiceHandler;
import org.jclouds.vcloud.terremark.xml.InternetServicesHandler;
import org.jclouds.vcloud.terremark.xml.KeyPairByNameHandler;
import org.jclouds.vcloud.terremark.xml.KeyPairHandler;
import org.jclouds.vcloud.terremark.xml.KeyPairsHandler;
import org.jclouds.vcloud.terremark.xml.PublicIpAddressesHandler;
import org.jclouds.vcloud.terremark.xml.TerremarkNetworkHandler;
import org.jclouds.vcloud.terremark.xml.TerremarkOrgNetworkFromTerremarkVCloudExpressNetworkHandler;

@RequestFilters(value={SetVCloudTokenCookie.class})
public interface TerremarkECloudAsyncClient
extends TerremarkVCloudAsyncClient {
    @Override
    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServicesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<InternetService>> getAllInternetServicesInVDC(@EndpointParam(parser=VDCURIToInternetServicesEndpoint.class) URI var1);

    @POST
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.publicIp+xml"})
    @XMLResponseParser(value=PublicIpAddressesHandler.class)
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<PublicIpAddress> activatePublicIpInVDC(@EndpointParam(parser=VDCURIToPublicIPsEndpoint.class) URI var1);

    @Override
    @POST
    @Path(value="/internetServices")
    @Produces(value={"application/vnd.tmrk.ecloud.internetService+xml"})
    @Consumes(value={"application/vnd.tmrk.ecloud.internetService+xml"})
    @XMLResponseParser(value=InternetServiceHandler.class)
    @MapBinder(value=AddInternetServiceOptions.class)
    public ListenableFuture<? extends InternetService> addInternetServiceToExistingIp(@EndpointParam URI var1, @MapPayloadParam(value="name") String var2, @MapPayloadParam(value="protocol") Protocol var3, @MapPayloadParam(value="port") int var4, AddInternetServiceOptions ... var5);

    @Override
    @GET
    @Path(value="/internetServices")
    @Consumes(value={"application/vnd.tmrk.ecloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServicesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<InternetService>> getInternetServicesOnPublicIp(@EndpointParam URI var1);

    @Override
    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServiceHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends InternetService> getInternetService(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=KeyPairByNameHandler.class)
    @Consumes(value={"application/vnd.tmrk.ecloud.keysList+xml"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends KeyPair> findKeyPairInOrg(@Nullable @EndpointParam(parser=OrgURIToKeysListEndpoint.class) URI var1, String var2);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.keysList+xml"})
    @XMLResponseParser(value=KeyPairsHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<KeyPair>> listKeyPairsInOrg(@Nullable @EndpointParam(parser=OrgURIToKeysListEndpoint.class) URI var1);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.ecloud.keysList+xml"})
    @XMLResponseParser(value=KeyPairsHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<KeyPair>> listKeyPairs(@EndpointParam URI var1);

    @POST
    @Path(value="")
    @Produces(value={"application/vnd.tmrk.ecloud.keysList+xml"})
    @Consumes(value={"application/vnd.tmrk.ecloud.keysList+xml"})
    @XMLResponseParser(value=KeyPairHandler.class)
    @MapBinder(value=BindCreateKeyToXmlPayload.class)
    public ListenableFuture<? extends KeyPair> generateKeyPairInOrg(@EndpointParam(parser=OrgURIToKeysListEndpoint.class) URI var1, @MapPayloadParam(value="name") String var2, @MapPayloadParam(value="isDefault") boolean var3);

    @GET
    @Path(value="")
    @XMLResponseParser(value=KeyPairHandler.class)
    @Consumes(value={"application/xml"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends KeyPair> getKeyPair(@EndpointParam URI var1);

    @DELETE
    @Path(value="")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteKeyPair(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.vmware.vcloud.network+xml"})
    @XMLResponseParser(value=TerremarkOrgNetworkFromTerremarkVCloudExpressNetworkHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends TerremarkOrgNetwork> findNetworkInOrgVDCNamed(@Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var1, @Nullable @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var2, @EndpointParam(parser=OrgNameVDCNameResourceEntityNameToEndpoint.class) String var3);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.vmware.vcloud.network+xml"})
    @XMLResponseParser(value=TerremarkOrgNetworkFromTerremarkVCloudExpressNetworkHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends TerremarkOrgNetwork> getNetwork(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=TerremarkNetworkHandler.class)
    @Consumes(value={"application/xml"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends TerremarkNetwork> getTerremarkNetwork(@EndpointParam URI var1);
}

