/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.jclouds.predicates.validators.DnsNameValidator;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.MapPayloadParam;
import org.jclouds.rest.annotations.ParamValidators;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnVoidOnNotFoundOr404;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.domain.Catalog;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.filters.SetVCloudTokenCookie;
import org.jclouds.vcloud.functions.OrgNameAndVDCNameToEndpoint;
import org.jclouds.vcloud.functions.OrgNameCatalogNameItemNameToEndpoint;
import org.jclouds.vcloud.functions.OrgNameToEndpoint;
import org.jclouds.vcloud.options.InstantiateVAppTemplateOptions;
import org.jclouds.vcloud.terremark.binders.BindNodeConfigurationToXmlPayload;
import org.jclouds.vcloud.terremark.binders.BindVAppConfigurationToXmlPayload;
import org.jclouds.vcloud.terremark.binders.TerremarkBindInstantiateVAppTemplateParamsToXmlPayload;
import org.jclouds.vcloud.terremark.domain.CustomizationParameters;
import org.jclouds.vcloud.terremark.domain.InternetService;
import org.jclouds.vcloud.terremark.domain.Node;
import org.jclouds.vcloud.terremark.domain.Protocol;
import org.jclouds.vcloud.terremark.domain.PublicIpAddress;
import org.jclouds.vcloud.terremark.domain.TerremarkCatalogItem;
import org.jclouds.vcloud.terremark.domain.TerremarkOrg;
import org.jclouds.vcloud.terremark.domain.TerremarkVDC;
import org.jclouds.vcloud.terremark.domain.VAppConfiguration;
import org.jclouds.vcloud.terremark.functions.ParseTaskFromLocationHeader;
import org.jclouds.vcloud.terremark.functions.ReturnVoidOnDeleteDefaultIp;
import org.jclouds.vcloud.terremark.functions.VDCURIToInternetServicesEndpoint;
import org.jclouds.vcloud.terremark.functions.VDCURIToPublicIPsEndpoint;
import org.jclouds.vcloud.terremark.options.AddInternetServiceOptions;
import org.jclouds.vcloud.terremark.options.AddNodeOptions;
import org.jclouds.vcloud.terremark.xml.CustomizationParametersHandler;
import org.jclouds.vcloud.terremark.xml.InternetServiceHandler;
import org.jclouds.vcloud.terremark.xml.InternetServicesHandler;
import org.jclouds.vcloud.terremark.xml.NodeHandler;
import org.jclouds.vcloud.terremark.xml.NodesHandler;
import org.jclouds.vcloud.terremark.xml.PublicIpAddressesHandler;
import org.jclouds.vcloud.terremark.xml.TerremarkCatalogItemHandler;
import org.jclouds.vcloud.terremark.xml.TerremarkOrgHandler;
import org.jclouds.vcloud.terremark.xml.TerremarkVDCHandler;
import org.jclouds.vcloud.xml.CatalogHandler;
import org.jclouds.vcloud.xml.VCloudExpressVAppHandler;

@RequestFilters(value={SetVCloudTokenCookie.class})
public interface TerremarkVCloudAsyncClient
extends VCloudExpressAsyncClient {
    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.vmware.vcloud.catalogItem+xml"})
    @XMLResponseParser(value=TerremarkCatalogItemHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends TerremarkCatalogItem> findCatalogItemInOrgCatalogNamed(@Nullable @EndpointParam(parser=OrgNameCatalogNameItemNameToEndpoint.class) String var1, @Nullable @EndpointParam(parser=OrgNameCatalogNameItemNameToEndpoint.class) String var2, @Nullable @EndpointParam(parser=OrgNameCatalogNameItemNameToEndpoint.class) String var3);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.vmware.vcloud.catalogItem+xml"})
    @XMLResponseParser(value=TerremarkCatalogItemHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends TerremarkCatalogItem> getCatalogItem(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=TerremarkOrgHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/vnd.vmware.vcloud.org+xml"})
    public ListenableFuture<? extends TerremarkOrg> getOrg(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=TerremarkOrgHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Consumes(value={"application/vnd.vmware.vcloud.org+xml"})
    public ListenableFuture<? extends TerremarkOrg> findOrgNamed(@Nullable @EndpointParam(parser=OrgNameToEndpoint.class) String var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=CatalogHandler.class)
    @Consumes(value={"application/vnd.vmware.vcloud.catalog+xml"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Catalog> getCatalog(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=TerremarkVDCHandler.class)
    @Consumes(value={"application/vnd.vmware.vcloud.vdc+xml"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends TerremarkVDC> getVDC(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=TerremarkVDCHandler.class)
    @Consumes(value={"application/vnd.vmware.vcloud.vdc+xml"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends VDC> findVDCInOrgNamed(@Nullable @EndpointParam(parser=OrgNameAndVDCNameToEndpoint.class) String var1, @Nullable @EndpointParam(parser=OrgNameAndVDCNameToEndpoint.class) String var2);

    @POST
    @Path(value="/action/instantiateVAppTemplate")
    @Produces(value={"application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @XMLResponseParser(value=VCloudExpressVAppHandler.class)
    @MapBinder(value=TerremarkBindInstantiateVAppTemplateParamsToXmlPayload.class)
    public ListenableFuture<? extends VCloudExpressVApp> instantiateVAppTemplateInVDC(@EndpointParam URI var1, @MapPayloadParam(value="template") URI var2, @MapPayloadParam(value="name") @ParamValidators(value={DnsNameValidator.class}) String var3, InstantiateVAppTemplateOptions ... var4);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.vCloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServicesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<InternetService>> getAllInternetServicesInVDC(@EndpointParam(parser=VDCURIToInternetServicesEndpoint.class) URI var1);

    @POST
    @Path(value="/internetServices")
    @Produces(value={"application/vnd.tmrk.vCloud.internetService+xml"})
    @Consumes(value={"application/vnd.tmrk.vCloud.internetService+xml"})
    @XMLResponseParser(value=InternetServiceHandler.class)
    @MapBinder(value=AddInternetServiceOptions.class)
    public ListenableFuture<? extends InternetService> addInternetServiceToExistingIp(@EndpointParam URI var1, @MapPayloadParam(value="name") String var2, @MapPayloadParam(value="protocol") Protocol var3, @MapPayloadParam(value="port") int var4, AddInternetServiceOptions ... var5);

    @DELETE
    @Path(value="")
    @ExceptionParser(value=ReturnVoidOnDeleteDefaultIp.class)
    public ListenableFuture<Void> deletePublicIp(@EndpointParam URI var1);

    @GET
    @Path(value="/internetServices")
    @Consumes(value={"application/vnd.tmrk.vCloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServicesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<InternetService>> getInternetServicesOnPublicIp(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.vCloud.publicIp+xml"})
    @XMLResponseParser(value=InternetServicesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<InternetService>> getPublicIp(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.vCloud.publicIpsList+xml"})
    @XMLResponseParser(value=PublicIpAddressesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<PublicIpAddress>> getPublicIpsAssociatedWithVDC(@EndpointParam(parser=VDCURIToPublicIPsEndpoint.class) URI var1);

    @DELETE
    @Path(value="")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteInternetService(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @Consumes(value={"application/vnd.tmrk.vCloud.internetServicesList+xml"})
    @XMLResponseParser(value=InternetServiceHandler.class)
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends InternetService> getInternetService(@EndpointParam URI var1);

    @POST
    @Path(value="/nodeServices")
    @Produces(value={"application/vnd.tmrk.vCloud.nodeService+xml"})
    @Consumes(value={"application/vnd.tmrk.vCloud.nodeService+xml"})
    @XMLResponseParser(value=NodeHandler.class)
    @MapBinder(value=AddNodeOptions.class)
    public ListenableFuture<? extends Node> addNode(@EndpointParam URI var1, @MapPayloadParam(value="ipAddress") String var2, @MapPayloadParam(value="name") String var3, @MapPayloadParam(value="port") int var4, AddNodeOptions ... var5);

    @GET
    @Path(value="/nodeServices")
    @XMLResponseParser(value=NodesHandler.class)
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    @Consumes(value={"application/vnd.tmrk.vCloud.nodeService+xml"})
    public ListenableFuture<? extends Set<Node>> getNodes(@EndpointParam URI var1);

    @GET
    @Path(value="")
    @XMLResponseParser(value=NodeHandler.class)
    @Consumes(value={"application/vnd.tmrk.vCloud.nodeService+xml"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<? extends Node> getNode(@EndpointParam URI var1);

    @PUT
    @Path(value="")
    @Produces(value={"application/vnd.tmrk.vCloud.nodeService+xml"})
    @Consumes(value={"application/vnd.tmrk.vCloud.nodeService+xml"})
    @XMLResponseParser(value=NodeHandler.class)
    @MapBinder(value=BindNodeConfigurationToXmlPayload.class)
    public ListenableFuture<? extends Node> configureNode(@EndpointParam URI var1, @MapPayloadParam(value="name") String var2, @MapPayloadParam(value="enabled") boolean var3, @Nullable @MapPayloadParam(value="description") String var4);

    @DELETE
    @Path(value="")
    @ExceptionParser(value=ReturnVoidOnNotFoundOr404.class)
    public ListenableFuture<Void> deleteNode(@EndpointParam URI var1);

    @PUT
    @Path(value="")
    @Produces(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @Consumes(value={"application/vnd.vmware.vcloud.vApp+xml"})
    @MapBinder(value=BindVAppConfigurationToXmlPayload.class)
    @ResponseParser(value=ParseTaskFromLocationHeader.class)
    public ListenableFuture<? extends Task> configureVApp(@EndpointParam(parser=BindVAppConfigurationToXmlPayload.class) VCloudExpressVApp var1, VAppConfiguration var2);

    @GET
    @Path(value="")
    @XMLResponseParser(value=CustomizationParametersHandler.class)
    @Consumes(value={"application/vnd.tmrk.vCloud.catalogItemCustomizationParameters+xml"})
    public ListenableFuture<? extends CustomizationParameters> getCustomizationOptions(@EndpointParam URI var1);
}

