/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.util.Patterns;
import org.jclouds.util.Utils;

@Singleton
public class BindAddNodeServiceToXmlPayload
implements MapBinder {
    @Inject
    @Named(value="CreateNodeService")
    private String xmlTemplate;
    @Inject
    private BindToStringPayload stringBinder;
    @Inject
    @Named(value="jclouds.terremark.extension.ns")
    private String ns;

    public void bindToRequest(HttpRequest request, Map<String, String> postParams) {
        String ipAddress = (String)Preconditions.checkNotNull((Object)postParams.get("ipAddress"), (Object)"ipAddress parameter not present");
        String name = (String)Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present");
        String port = (String)Preconditions.checkNotNull((Object)postParams.get("port"), (Object)"port parameter not present");
        String enabled = (String)Preconditions.checkNotNull((Object)postParams.get("enabled"), (Object)"enabled parameter not present");
        String description = postParams.get("description");
        String payload = Utils.replaceTokens((String)this.xmlTemplate, (Map)ImmutableMap.of((Object)"name", (Object)name, (Object)"ipAddress", (Object)ipAddress, (Object)"port", (Object)port, (Object)"enabled", (Object)enabled, (Object)"ns", (Object)this.ns));
        payload = Utils.replaceAll((String)payload, (Pattern)((Pattern)Patterns.TOKEN_TO_PATTERN.get("description")), (String)(description == null ? "" : String.format("\n    <Description>%s</Description>", description)));
        this.stringBinder.bindToRequest(request, (Object)payload);
    }

    public void bindToRequest(HttpRequest request, Object input) {
        throw new IllegalStateException("CreateNodeService needs parameters");
    }
}

