/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.binders;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;

@Singleton
public class BindNodeConfigurationToXmlPayload
implements MapBinder {
    private final String ns;
    private final BindToStringPayload stringBinder;

    @Inject
    BindNodeConfigurationToXmlPayload(@Named(value="jclouds.terremark.extension.ns") String ns, BindToStringPayload stringBinder) {
        this.ns = ns;
        this.stringBinder = stringBinder;
    }

    protected String generateXml(Map<String, String> postParams) throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder rootBuilder = XMLBuilder.create((String)"NodeService").a("xmlns", this.ns).a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        rootBuilder.e("Name").t((String)Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name"));
        rootBuilder.e("Enabled").t((String)Preconditions.checkNotNull((Object)postParams.get("enabled"), (Object)"enabled"));
        if (postParams.containsKey("description") && postParams.get("description") != null) {
            rootBuilder.e("Description").t(postParams.get("description"));
        }
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        return rootBuilder.asString(outputProperties);
    }

    public void bindToRequest(HttpRequest request, Map<String, String> postParams) {
        try {
            this.stringBinder.bindToRequest(request, (Object)this.generateXml(postParams));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void bindToRequest(HttpRequest request, Object input) {
        throw new IllegalArgumentException("this is a map binder");
    }
}

