/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.config.BindComputeStrategiesByClass;
import org.jclouds.compute.config.BindComputeSuppliersByClass;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.compute.strategy.PopulateDefaultLoginCredentialsForImageStrategy;
import org.jclouds.vcloud.compute.VCloudExpressComputeClient;
import org.jclouds.vcloud.compute.config.VCloudExpressComputeServiceContextModule;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.terremark.compute.TerremarkVCloudComputeClient;
import org.jclouds.vcloud.terremark.compute.TerremarkVCloudComputeService;
import org.jclouds.vcloud.terremark.compute.config.TerremarkBindComputeStrategiesByClass;
import org.jclouds.vcloud.terremark.compute.config.TerremarkBindComputeSuppliersByClass;
import org.jclouds.vcloud.terremark.compute.domain.KeyPairCredentials;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;
import org.jclouds.vcloud.terremark.compute.functions.NodeMetadataToOrgAndName;
import org.jclouds.vcloud.terremark.compute.functions.TerremarkVCloudExpressVAppToNodeMetadata;
import org.jclouds.vcloud.terremark.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.vcloud.terremark.compute.strategy.ParseVAppTemplateDescriptionToGetDefaultLoginCredentials;

public class TerremarkVCloudComputeServiceContextModule
extends VCloudExpressComputeServiceContextModule {
    @Provides
    @Singleton
    Supplier<String> provideSuffix(final SecureRandom random) {
        return new Supplier<String>(){

            public String get() {
                return random.nextInt(4096) + "";
            }
        };
    }

    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.UBUNTU).osDescriptionMatches(".*JeOS.*").os64Bit(true);
    }

    protected void configure() {
        super.configure();
        this.bind((TypeLiteral)new TypeLiteral<Function<NodeMetadata, OrgAndName>>(){}).to((TypeLiteral)new TypeLiteral<NodeMetadataToOrgAndName>(){});
        this.bind(TemplateOptions.class).to(TerremarkVCloudTemplateOptions.class);
        this.bind(ComputeService.class).to(TerremarkVCloudComputeService.class);
        this.bind(VCloudExpressComputeClient.class).to(TerremarkVCloudComputeClient.class);
        this.bind(PopulateDefaultLoginCredentialsForImageStrategy.class).to(ParseVAppTemplateDescriptionToGetDefaultLoginCredentials.class);
        this.bind(SecureRandom.class).toInstance((Object)new SecureRandom());
    }

    protected void bindVAppConverter() {
        this.bind((TypeLiteral)new TypeLiteral<Function<VCloudExpressVApp, NodeMetadata>>(){}).to(TerremarkVCloudExpressVAppToNodeMetadata.class);
    }

    public BindComputeStrategiesByClass defineComputeStrategyModule() {
        return new TerremarkBindComputeStrategiesByClass();
    }

    public BindComputeSuppliersByClass defineComputeSupplierModule() {
        return new TerremarkBindComputeSuppliersByClass();
    }

    @Provides
    @Singleton
    ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap() {
        return new ConcurrentHashMap<OrgAndName, KeyPairCredentials>();
    }

    @Named(value="PASSWORD")
    @Provides
    String providePassword(SecureRandom random) {
        return random.nextLong() + "";
    }
}

