/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.endpoints.VDC;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;

@Singleton
public class NodeMetadataToOrgAndName
implements Function<NodeMetadata, OrgAndName> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    final Supplier<Map<String, String>> vdcToOrg;
    private final VCloudExpressClient client;

    @Inject
    NodeMetadataToOrgAndName(VCloudExpressClient client, @VDC Supplier<Map<String, String>> vdcToOrg) {
        this.vdcToOrg = vdcToOrg;
        this.client = client;
    }

    public OrgAndName apply(NodeMetadata from) {
        if (from.getTag() != null) {
            Org org = this.client.findOrgNamed((String)((Map)this.vdcToOrg.get()).get(from.getLocation().getId()));
            if (org == null) {
                this.logger.warn("did not find an association for vdc %s in %s", new Object[]{from.getLocation().getId(), this.vdcToOrg});
            } else {
                return new OrgAndName(org.getHref(), from.getTag());
            }
        }
        return null;
    }
}

