/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.domain.Credentials;
import org.jclouds.vcloud.compute.VCloudExpressComputeClient;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.functions.HardwareForVCloudExpressVApp;
import org.jclouds.vcloud.compute.functions.VCloudExpressVAppToNodeMetadata;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.terremark.compute.domain.KeyPairCredentials;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;

@Singleton
public class TerremarkVCloudExpressVAppToNodeMetadata
extends VCloudExpressVAppToNodeMetadata {
    private final ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap;

    @Inject
    public TerremarkVCloudExpressVAppToNodeMetadata(VCloudExpressComputeClient computeClient, Map<String, Credentials> credentialStore, Map<Status, NodeState> vAppStatusToNodeState, HardwareForVCloudExpressVApp hardwareForVCloudExpressVApp, FindLocationForResource findLocationForResourceInVDC, @Memoized Supplier<Set<? extends Image>> images, ConcurrentMap<OrgAndName, KeyPairCredentials> credentialsMap) {
        super(computeClient, credentialStore, vAppStatusToNodeState, hardwareForVCloudExpressVApp, findLocationForResourceInVDC, images);
        this.credentialsMap = (ConcurrentMap)Preconditions.checkNotNull(credentialsMap, (Object)"credentialsMap");
    }

    public NodeMetadata apply(VCloudExpressVApp from) {
        NodeMetadata node = super.apply(from);
        if (node == null) {
            return null;
        }
        if (node.getTag() != null) {
            node = this.installCredentialsFromCache(node);
        }
        return node;
    }

    NodeMetadata installCredentialsFromCache(NodeMetadata node) {
        String adminPasswordKey;
        OrgAndName orgAndName = this.getOrgAndNameFromNode(node);
        if (this.credentialsMap.containsKey(orgAndName)) {
            Credentials creds = (Credentials)this.credentialsMap.get(orgAndName);
            node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).credentials(creds).build();
            this.credentialStore.put("node#" + node.getId(), creds);
        }
        if (this.credentialStore.containsKey(adminPasswordKey = "node#" + node.getId() + "#adminPassword")) {
            node = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node).adminPassword(((Credentials)this.credentialStore.get((Object)adminPasswordKey)).credential).build();
        }
        return node;
    }

    OrgAndName getOrgAndNameFromNode(NodeMetadata node) {
        URI orgId = URI.create(node.getLocation().getParent().getId());
        OrgAndName orgAndName = new OrgAndName(orgId, node.getTag());
        return orgAndName;
    }
}

