/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.options;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.io.Payload;
import org.jclouds.util.Utils;

public class TerremarkVCloudTemplateOptions
extends TemplateOptions {
    private String keyPair = null;
    private boolean noKeyPair;
    public static final TerremarkVCloudTemplateOptions NONE = new TerremarkVCloudTemplateOptions();

    public TerremarkVCloudTemplateOptions sshKeyFingerprint(String keyPair) {
        Preconditions.checkNotNull((Object)keyPair, (Object)"use noKeyPair option to request boot without a keypair");
        Preconditions.checkState((!this.noKeyPair ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        Utils.checkNotEmpty((String)keyPair, (String)"keypair must be non-empty");
        this.keyPair = keyPair;
        return this;
    }

    public TerremarkVCloudTemplateOptions noKeyPair() {
        Preconditions.checkState((this.keyPair == null ? 1 : 0) != 0, (Object)"you cannot specify both options keyPair and noKeyPair");
        this.noKeyPair = true;
        return this;
    }

    public TerremarkVCloudTemplateOptions blockOnPort(int port, int seconds) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.blockOnPort(port, seconds)));
    }

    public TerremarkVCloudTemplateOptions inboundPorts(int ... ports) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.inboundPorts(ports)));
    }

    public TerremarkVCloudTemplateOptions authorizePublicKey(String publicKey) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.authorizePublicKey(publicKey)));
    }

    @Deprecated
    public TerremarkVCloudTemplateOptions authorizePublicKey(Payload publicKey) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.authorizePublicKey(publicKey)));
    }

    public TerremarkVCloudTemplateOptions installPrivateKey(String privateKey) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.installPrivateKey(privateKey)));
    }

    @Deprecated
    public TerremarkVCloudTemplateOptions installPrivateKey(Payload privateKey) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.installPrivateKey(privateKey)));
    }

    public TerremarkVCloudTemplateOptions runScript(Payload script) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.runScript(script)));
    }

    @Deprecated
    public TerremarkVCloudTemplateOptions runScript(byte[] script) {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.runScript(script)));
    }

    public TerremarkVCloudTemplateOptions withMetadata() {
        return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(super.withMetadata()));
    }

    public String getSshKeyFingerprint() {
        return this.keyPair;
    }

    public boolean shouldAutomaticallyCreateKeyPair() {
        return !this.noKeyPair;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyPair == null ? 0 : this.keyPair.hashCode());
        result = 31 * result + (this.noKeyPair ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TerremarkVCloudTemplateOptions other = (TerremarkVCloudTemplateOptions)((Object)obj);
        if (this.keyPair == null ? other.keyPair != null : !this.keyPair.equals(other.keyPair)) {
            return false;
        }
        return this.noKeyPair == other.noKeyPair;
    }

    public String toString() {
        return "TerremarkVCloudTemplateOptions [keyPair=" + this.keyPair + ", noKeyPair=" + this.noKeyPair + ", inboundPorts=" + Arrays.toString(this.inboundPorts) + ", privateKey=" + (this.privateKey != null) + ", publicKey=" + (this.publicKey != null) + ", runScript=" + (this.script != null) + ", port:seconds=" + this.port + ":" + this.seconds + ", metadata/details: " + this.includeMetadata + "]";
    }

    public static class Builder {
        public static TerremarkVCloudTemplateOptions sshKeyFingerprint(String keyPair) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.sshKeyFingerprint(keyPair)));
        }

        public static TerremarkVCloudTemplateOptions noKeyPair() {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.noKeyPair()));
        }

        public static TerremarkVCloudTemplateOptions inboundPorts(int ... ports) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.inboundPorts(ports)));
        }

        public static TerremarkVCloudTemplateOptions blockOnPort(int port, int seconds) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.blockOnPort(port, seconds)));
        }

        public static TerremarkVCloudTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast(options.blockUntilRunning(blockUntilRunning)));
        }

        public static TerremarkVCloudTemplateOptions runScript(byte[] script) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.runScript(script)));
        }

        public static TerremarkVCloudTemplateOptions installPrivateKey(String rsaKey) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.installPrivateKey(rsaKey)));
        }

        public static TerremarkVCloudTemplateOptions authorizePublicKey(String rsaKey) {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.authorizePublicKey(rsaKey)));
        }

        public static TerremarkVCloudTemplateOptions withDetails() {
            TerremarkVCloudTemplateOptions options = new TerremarkVCloudTemplateOptions();
            return (TerremarkVCloudTemplateOptions)((Object)TerremarkVCloudTemplateOptions.class.cast((Object)options.withMetadata()));
        }
    }
}

