/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.vcloud.terremark.compute.domain.OrgAndName;
import org.jclouds.vcloud.terremark.compute.strategy.DeleteKeyPair;

@Singleton
public class CleanupOrphanKeys {
    final Function<NodeMetadata, OrgAndName> nodeToOrgAndName;
    final DeleteKeyPair deleteKeyPair;
    final ListNodesStrategy listNodes;
    final Map<String, Credentials> credentialStore;

    @Inject
    CleanupOrphanKeys(Function<NodeMetadata, OrgAndName> nodeToOrgAndName, DeleteKeyPair deleteKeyPair, Map<String, Credentials> credentialStore, ListNodesStrategy listNodes) {
        this.nodeToOrgAndName = nodeToOrgAndName;
        this.deleteKeyPair = deleteKeyPair;
        this.listNodes = listNodes;
        this.credentialStore = credentialStore;
    }

    public void execute(Iterable<? extends NodeMetadata> deadOnes) {
        for (NodeMetadata nodeMetadata : deadOnes) {
            this.credentialStore.remove("node#" + nodeMetadata.getId());
            this.credentialStore.remove("node#" + nodeMetadata.getId() + "#adminPassword");
        }
        Iterable orgTags = Iterables.filter((Iterable)Iterables.transform(deadOnes, this.nodeToOrgAndName), (Predicate)Predicates.notNull());
        for (OrgAndName orgTag : orgTags) {
            Iterable nodesInOrg = this.listNodes.listDetailsOnNodesMatching(NodePredicates.parentLocationId((String)orgTag.getOrg().toASCIIString()));
            Iterable nodesWithTag = Iterables.filter((Iterable)nodesInOrg, (Predicate)NodePredicates.withTag((String)orgTag.getName()));
            if (Iterables.size((Iterable)nodesWithTag) != 0 && !Iterables.all((Iterable)nodesWithTag, (Predicate)NodePredicates.TERMINATED)) continue;
            this.deleteKeyPair.execute(orgTag);
        }
    }
}

