/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.AddNodeWithTagStrategy;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.EncodeTagIntoNameRunNodesAndAddToSetStrategy;
import org.jclouds.compute.util.ComputeUtils;
import org.jclouds.domain.LocationScope;
import org.jclouds.vcloud.terremark.compute.options.TerremarkVCloudTemplateOptions;
import org.jclouds.vcloud.terremark.compute.strategy.CreateNewKeyPairUnlessUserSpecifiedOtherwise;

@Singleton
public class TerremarkEncodeTagIntoNameRunNodesAndAddToSetStrategy
extends EncodeTagIntoNameRunNodesAndAddToSetStrategy {
    private final CreateNewKeyPairUnlessUserSpecifiedOtherwise createNewKeyPairUnlessUserSpecifiedOtherwise;

    @Inject
    protected TerremarkEncodeTagIntoNameRunNodesAndAddToSetStrategy(AddNodeWithTagStrategy addNodeWithTagStrategy, ListNodesStrategy listNodesStrategy, @Named(value="NAMING_CONVENTION") String nodeNamingConvention, ComputeUtils utils, @Named(value="jclouds.user-threads") ExecutorService executor, CreateNewKeyPairUnlessUserSpecifiedOtherwise createNewKeyPairUnlessUserSpecifiedOtherwise) {
        super(addNodeWithTagStrategy, listNodesStrategy, nodeNamingConvention, utils, executor);
        this.createNewKeyPairUnlessUserSpecifiedOtherwise = createNewKeyPairUnlessUserSpecifiedOtherwise;
    }

    public Map<?, Future<Void>> execute(String tag, int count, Template template, Set<NodeMetadata> nodes, Map<NodeMetadata, Exception> badNodes) {
        assert (template.getLocation().getParent().getScope() == LocationScope.REGION) : "template location should have a parent of org, which should be mapped to region: " + template.getLocation();
        String orgId = template.getLocation().getParent().getId();
        assert (orgId.startsWith("http")) : "parent id should be a rest url: " + template.getLocation().getParent();
        this.createNewKeyPairUnlessUserSpecifiedOtherwise.execute(URI.create(orgId), tag, template.getImage().getDefaultCredentials().identity, (TerremarkVCloudTemplateOptions)template.getOptions().as(TerremarkVCloudTemplateOptions.class));
        return super.execute(tag, count, template, nodes, badNodes);
    }
}

