/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.AddNodeWithTagStrategy;
import org.jclouds.domain.Credentials;
import org.jclouds.vcloud.domain.VCloudExpressVApp;
import org.jclouds.vcloud.terremark.compute.TerremarkVCloudComputeClient;
import org.jclouds.vcloud.terremark.compute.functions.TemplateToInstantiateOptions;
import org.jclouds.vcloud.terremark.options.TerremarkInstantiateVAppTemplateOptions;

@Singleton
public class TerremarkVCloudAddNodeWithTagStrategy
implements AddNodeWithTagStrategy {
    protected final TerremarkVCloudComputeClient computeClient;
    protected final TemplateToInstantiateOptions getOptions;
    protected final Function<VCloudExpressVApp, NodeMetadata> vAppToNodeMetadata;
    private final Map<String, Credentials> credentialStore;

    @Inject
    protected TerremarkVCloudAddNodeWithTagStrategy(TerremarkVCloudComputeClient computeClient, Function<VCloudExpressVApp, NodeMetadata> vAppToNodeMetadata, TemplateToInstantiateOptions getOptions, Map<String, Credentials> credentialStore) {
        this.computeClient = computeClient;
        this.vAppToNodeMetadata = vAppToNodeMetadata;
        this.getOptions = (TemplateToInstantiateOptions)Preconditions.checkNotNull((Object)getOptions, (Object)"getOptions");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
    }

    public NodeMetadata addNodeWithTag(String tag, String name, Template template) {
        TerremarkInstantiateVAppTemplateOptions options = this.getOptions.apply(template);
        VCloudExpressVApp vApp = this.computeClient.start(URI.create(template.getLocation().getId()), URI.create(template.getImage().getId()), name, options, template.getOptions().getInboundPorts());
        NodeMetadata node = (NodeMetadata)this.vAppToNodeMetadata.apply((Object)vApp);
        NodeMetadataBuilder builder = NodeMetadataBuilder.fromNodeMetadata((NodeMetadata)node);
        if (template.getImage().getAdminPassword() != null) {
            builder.adminPassword(template.getImage().getAdminPassword());
            this.credentialStore.put("node#" + node.getId() + "#adminPassword", new Credentials("root", template.getImage().getAdminPassword()));
        }
        return builder.build();
    }
}

