/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Injector;
import com.google.inject.Provides;
import java.net.URI;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.inject.Singleton;
import org.jclouds.http.RequiresHttp;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.vcloud.VCloudExpressAsyncClient;
import org.jclouds.vcloud.VCloudExpressClient;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.terremark.TerremarkECloudAsyncClient;
import org.jclouds.vcloud.terremark.TerremarkECloudClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudAsyncClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudClient;
import org.jclouds.vcloud.terremark.config.TerremarkRestClientModule;
import org.jclouds.vcloud.terremark.domain.TerremarkNetwork;
import org.jclouds.vcloud.terremark.domain.TerremarkOrgNetwork;

@RequiresHttp
@ConfiguresRestClient
public class TerremarkECloudRestClientModule
extends TerremarkRestClientModule<TerremarkECloudClient, TerremarkECloudAsyncClient> {
    public TerremarkECloudRestClientModule() {
        super(TerremarkECloudClient.class, TerremarkECloudAsyncClient.class);
    }

    @Provides
    @Singleton
    protected VCloudExpressAsyncClient provideVCloudAsyncClient(TerremarkECloudAsyncClient in) {
        return in;
    }

    @Provides
    @Singleton
    protected VCloudExpressClient provideVCloudClient(TerremarkECloudClient in) {
        return in;
    }

    @Provides
    @Singleton
    protected TerremarkVCloudAsyncClient provideTerremarkAsyncClient(TerremarkECloudAsyncClient in) {
        return in;
    }

    @Provides
    @Singleton
    protected TerremarkVCloudClient provideTerremarkClient(TerremarkECloudClient in) {
        return in;
    }

    protected URI findDefaultNetworkForVDC(VDC vDC, Map<String, ReferenceType> networks, final Injector injector) {
        this.logger.warn("default network for vdc %s not set", new Object[]{vDC.getName()});
        try {
            return ((ReferenceType)Iterables.find(networks.values(), (Predicate)new Predicate<ReferenceType>(){

                public boolean apply(ReferenceType input) {
                    TerremarkOrgNetwork network = ((TerremarkECloudClient)injector.getInstance(TerremarkECloudClient.class)).getNetwork(input.getHref());
                    TerremarkNetwork terremarkNetwork = ((TerremarkECloudClient)injector.getInstance(TerremarkECloudClient.class)).getTerremarkNetwork(((ReferenceType)Preconditions.checkNotNull((Object)((TerremarkOrgNetwork)((Object)Preconditions.checkNotNull((Object)((Object)network), (Object)("network at: " + input)))).getNetworkExtension(), (Object)("network extension for: " + input))).getHref());
                    return ((TerremarkNetwork)Preconditions.checkNotNull((Object)terremarkNetwork, (Object)("terremark network extension at: " + network.getNetworkExtension()))).getNetworkType() == TerremarkNetwork.Type.DMZ;
                }
            })).getHref();
        }
        catch (NoSuchElementException e) {
            throw new ResourceNotFoundException("no dmz networks in vdc " + vDC.getName() + ": " + networks);
        }
    }
}

