/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.inject.Provides;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.suppliers.RetryOnTimeOutButNotOnAuthorizationExceptionSupplier;
import org.jclouds.util.Utils;
import org.jclouds.vcloud.config.BaseVCloudExpressRestClientModule;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.terremark.TerremarkVCloudAsyncClient;
import org.jclouds.vcloud.terremark.TerremarkVCloudClient;
import org.jclouds.vcloud.terremark.endpoints.KeysList;
import org.jclouds.vcloud.terremark.handlers.ParseTerremarkVCloudErrorFromHttpResponse;

public abstract class TerremarkRestClientModule<S extends TerremarkVCloudClient, A extends TerremarkVCloudAsyncClient>
extends BaseVCloudExpressRestClientModule<S, A> {
    public TerremarkRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
    }

    @Singleton
    @Provides
    @Named(value="CreateInternetService")
    String provideCreateInternetService() throws IOException {
        return Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateInternetService.xml"));
    }

    @Singleton
    @Provides
    @Named(value="CreateNodeService")
    String provideCreateNodeService() throws IOException {
        return Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateNodeService.xml"));
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseTerremarkVCloudErrorFromHttpResponse.class);
    }

    @Provides
    @Singleton
    @KeysList
    protected Supplier<Map<String, ReferenceType>> provideOrgToKeysListCache(@Named(value="jclouds.session-interval") long seconds, final OrgNameToKeysListSupplier supplier) {
        return new RetryOnTimeOutButNotOnAuthorizationExceptionSupplier(this.authException, seconds, (Supplier)new Supplier<Map<String, ReferenceType>>(){

            public Map<String, ReferenceType> get() {
                return supplier.get();
            }
        });
    }

    @Singleton
    @Provides
    @Named(value="CreateKey")
    String provideCreateKey() throws IOException {
        return Utils.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/terremark/CreateKey.xml"));
    }

    @Singleton
    public static class OrgNameToKeysListSupplier
    implements Supplier<Map<String, ReferenceType>> {
        protected final Supplier<VCloudSession> sessionSupplier;
        private final TerremarkVCloudClient client;

        @Inject
        protected OrgNameToKeysListSupplier(Supplier<VCloudSession> sessionSupplier, TerremarkVCloudClient client) {
            this.sessionSupplier = sessionSupplier;
            this.client = client;
        }

        public Map<String, ReferenceType> get() {
            return Maps.transformValues((Map)((VCloudSession)this.sessionSupplier.get()).getOrgs(), (Function)new Function<ReferenceType, ReferenceType>(){

                public ReferenceType apply(ReferenceType from) {
                    return OrgNameToKeysListSupplier.this.client.findOrgNamed(from.getName()).getKeysList();
                }
            });
        }
    }
}

