/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class IpAddress
implements Comparable<IpAddress> {
    private final String address;
    private final Status status;
    @Nullable
    private final String server;

    public IpAddress(String address, Status status, String server) {
        this.address = address;
        this.status = status;
        this.server = server;
    }

    public String getAddress() {
        return this.address;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getServer() {
        return this.server;
    }

    public String toString() {
        return "IpAddress [address=" + this.address + ", server=" + this.server + ", status=" + (Object)((Object)this.status) + "]";
    }

    @Override
    public int compareTo(IpAddress o) {
        return this == o ? 0 : this.getAddress().compareTo(o.getAddress());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpAddress other = (IpAddress)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.server == null ? other.server != null : !this.server.equals(other.server)) {
            return false;
        }
        return !(this.status == null ? other.status != null : !this.status.equals((Object)other.status));
    }

    public static enum Status {
        AVAILABLE,
        ASSIGNED,
        UNRECOGNIZED;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Status fromValue(String status) {
            try {
                return Status.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)status, (Object)"status")));
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

