/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.domain.internal;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;
import org.jclouds.vcloud.domain.AllocationModel;
import org.jclouds.vcloud.domain.Capacity;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VDCStatus;
import org.jclouds.vcloud.domain.internal.VDCImpl;
import org.jclouds.vcloud.terremark.domain.TerremarkVDC;

public class TerremarkVDCImpl
extends VDCImpl
implements TerremarkVDC {
    private final ReferenceType catalog;
    private final ReferenceType publicIps;
    private final ReferenceType internetServices;
    private static final long serialVersionUID = 8464716396538298809L;

    public TerremarkVDCImpl(String name, String type, URI id, VDCStatus status, ReferenceType org, @Nullable String description, Iterable<Task> tasks, AllocationModel allocationModel, @Nullable Capacity storageCapacity, @Nullable Capacity cpuCapacity, @Nullable Capacity memoryCapacity, Map<String, ReferenceType> resourceEntities, Map<String, ReferenceType> availableNetworks, int nicQuota, int networkQuota, int vmQuota, boolean isEnabled, ReferenceType catalog, ReferenceType publicIps, ReferenceType internetServices) {
        super(name, type, id, status, org, description, tasks, allocationModel, storageCapacity, cpuCapacity, memoryCapacity, resourceEntities, availableNetworks, nicQuota, networkQuota, vmQuota, isEnabled);
        this.catalog = (ReferenceType)Preconditions.checkNotNull((Object)catalog, (Object)"catalog");
        this.publicIps = (ReferenceType)Preconditions.checkNotNull((Object)publicIps, (Object)"publicIps");
        this.internetServices = (ReferenceType)Preconditions.checkNotNull((Object)internetServices, (Object)"internetServices");
    }

    @Override
    public ReferenceType getCatalog() {
        return this.catalog;
    }

    @Override
    public ReferenceType getPublicIps() {
        return this.publicIps;
    }

    @Override
    public ReferenceType getInternetServices() {
        return this.internetServices;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
        result = 31 * result + (this.internetServices == null ? 0 : this.internetServices.hashCode());
        result = 31 * result + (this.publicIps == null ? 0 : this.publicIps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TerremarkVDCImpl other = (TerremarkVDCImpl)obj;
        if (this.catalog == null ? other.catalog != null : !this.catalog.equals(other.catalog)) {
            return false;
        }
        if (this.internetServices == null ? other.internetServices != null : !this.internetServices.equals(other.internetServices)) {
            return false;
        }
        return !(this.publicIps == null ? other.publicIps != null : !this.publicIps.equals(other.publicIps));
    }
}

