/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.terremark.domain.TerremarkOrg;

@Singleton
public class OrgURIToKeysListEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<String, ? extends Org>> orgMap;
    private final URI defaultOrg;

    @Inject
    public OrgURIToKeysListEndpoint(Supplier<Map<String, ? extends Org>> orgMap, @org.jclouds.vcloud.endpoints.Org URI defaultUri) {
        this.orgMap = orgMap;
        this.defaultOrg = defaultUri;
    }

    public URI apply(Object from) {
        ImmutableMap uriToOrg = Maps.uniqueIndex(((Map)this.orgMap.get()).values(), (Function)new Function<Org, URI>(){

            public URI apply(Org from) {
                return from.getHref();
            }
        });
        try {
            return ((TerremarkOrg)TerremarkOrg.class.cast(uriToOrg.get(from == null ? this.defaultOrg : from))).getKeysList().getHref();
        }
        catch (NullPointerException e) {
            throw new ResourceNotFoundException("org " + from + " not found in: " + uriToOrg, (Throwable)e);
        }
    }
}

