/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.functions;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Date;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.TaskStatus;
import org.jclouds.vcloud.domain.internal.TaskImpl;

@Singleton
public class ParseTaskFromLocationHeader
implements Function<HttpResponse, Task> {
    public Task apply(HttpResponse from) {
        String location = from.getFirstHeaderOrNull("Location");
        if (location == null) {
            location = from.getFirstHeaderOrNull("location");
        }
        if (location != null) {
            return new TaskImpl(URI.create(location), null, TaskStatus.QUEUED, new Date(), null, null, null, null);
        }
        throw new HttpResponseException("no uri in headers or content", null, from);
    }
}

