/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.terremark.domain.TerremarkVDC;

@Singleton
public class VDCURIToInternetServicesEndpoint
implements Function<Object, URI> {
    private final Supplier<Map<URI, ? extends VDC>> orgVDCMap;
    private final URI defaultVDC;

    @Inject
    public VDCURIToInternetServicesEndpoint(Supplier<Map<URI, ? extends VDC>> orgVDCMap, @org.jclouds.vcloud.endpoints.VDC URI defaultVDC) {
        this.orgVDCMap = orgVDCMap;
        this.defaultVDC = defaultVDC;
    }

    public URI apply(Object from) {
        try {
            return ((TerremarkVDC)TerremarkVDC.class.cast(((Map)this.orgVDCMap.get()).get(from == null ? this.defaultVDC : from))).getInternetServices().getHref();
        }
        catch (NullPointerException e) {
            throw new ResourceNotFoundException("vdc " + from + " not found in " + this.orgVDCMap.get());
        }
    }
}

