/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.util.Utils;

@Singleton
public class ParseTerremarkVCloudErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final Pattern RESOURCE_PATTERN = Pattern.compile(".*/v[^/]+/([^/]+)/([0-9]+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleError(HttpCommand command, HttpResponse response) {
        Throwable exception = new HttpResponseException(command, response);
        try {
            String content = this.parseErrorFromContentOrNull(command, response);
            if (response.getMessage() != null && (response.getMessage().indexOf("because there is a pending task running") != -1 || response.getMessage().indexOf("because it is already powered off") != -1 || response.getMessage().indexOf("exists") != -1)) {
                exception = new IllegalStateException(response.getMessage(), exception);
                return;
            }
            switch (response.getStatusCode()) {
                case 400: {
                    exception = new IllegalArgumentException(response.getMessage(), exception);
                    return;
                }
                case 401: {
                    exception = new AuthorizationException(command.getRequest(), content);
                    return;
                }
                case 403: 
                case 404: {
                    String path = command.getRequest().getEndpoint().getPath();
                    Matcher matcher = RESOURCE_PATTERN.matcher(path);
                    String message = matcher.find() ? String.format("%s %s not found", matcher.group(1), matcher.group(2)) : path;
                    exception = new ResourceNotFoundException(message, exception);
                    return;
                }
                case 405: {
                    exception = new UnsupportedOperationException(response.getMessage(), exception);
                    return;
                }
                case 501: {
                    if (response.getMessage() == null) return;
                    if (response.getMessage().indexOf("NotImplemented") == -1) return;
                    exception = new UnsupportedOperationException(response.getMessage(), exception);
                    return;
                }
            }
            return;
        }
        finally {
            HttpUtils.releasePayload((HttpResponse)response);
            command.setException((Exception)exception);
        }
    }

    String parseErrorFromContentOrNull(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Utils.toStringAndClose((InputStream)response.getPayload().getInput());
            }
            catch (IOException e) {
                this.logger.warn((Throwable)e, "exception reading error from response", new Object[]{response});
            }
        }
        return null;
    }
}

