/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.terremark.domain.IpAddress;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IpAddressesHandler
extends ParseSax.HandlerWithResult<Set<IpAddress>> {
    protected StringBuilder currentText = new StringBuilder();
    @Resource
    protected Logger logger = Logger.NULL;
    private Set<IpAddress> addresses = Sets.newLinkedHashSet();
    private String address;
    private IpAddress.Status status;
    @Nullable
    private String server;
    private boolean skip;

    public Set<IpAddress> getResult() {
        return this.addresses;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (attributes.getIndex("xsi:nil") != -1) {
            this.skip = true;
            return;
        }
        this.skip = false;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("Name")) {
            this.address = this.currentOrNull();
        } else if (qName.equals("Status")) {
            this.status = IpAddress.Status.fromValue(this.currentOrNull());
        } else if (!this.skip && qName.equals("Server")) {
            this.server = this.currentOrNull();
        } else if (qName.equals("IpAddress")) {
            this.addresses.add(new IpAddress(this.address, this.status, this.server));
            this.address = null;
            this.status = null;
            this.server = null;
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }
}

