/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import java.net.URI;
import javax.annotation.Resource;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.terremark.domain.TerremarkNetwork;

public class TerremarkNetworkHandler
extends ParseSax.HandlerWithResult<TerremarkNetwork> {
    @Resource
    protected Logger logger = Logger.NULL;
    private StringBuilder currentText = new StringBuilder();
    private String id;
    private URI href;
    private String name;
    private String rnatAddress;
    private String address;
    private String broadcastAddress;
    private String gatewayAddress;
    private TerremarkNetwork.Type networkType;
    private String vlan;
    private String friendlyName;

    protected String currentOrNull() {
        String returnVal = this.currentText.toString().trim();
        return returnVal.equals("") ? null : returnVal;
    }

    public TerremarkNetwork getResult() {
        return new TerremarkNetwork(this.id, this.href, this.name, this.rnatAddress, this.address, this.broadcastAddress, this.gatewayAddress, this.networkType, this.vlan, this.friendlyName);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("Href") && this.currentOrNull() != null) {
            this.href = URI.create(this.currentOrNull());
        } else if (qName.equals("Id")) {
            this.id = this.currentOrNull();
        } else if (qName.equals("Name")) {
            this.name = this.currentOrNull();
        } else if (qName.equals("RnatAddress")) {
            this.rnatAddress = this.currentOrNull();
        } else if (qName.equals("Address")) {
            this.address = this.currentOrNull();
        } else if (qName.equals("BroadcastAddress")) {
            this.broadcastAddress = this.currentOrNull();
        } else if (qName.equals("GatewayAddress")) {
            this.gatewayAddress = this.currentOrNull();
        } else if (qName.equals("NetworkType")) {
            this.networkType = TerremarkNetwork.Type.fromValue(this.currentOrNull());
        } else if (qName.equals("Vlan")) {
            this.vlan = this.currentOrNull();
        } else if (qName.equals("FriendlyName")) {
            this.friendlyName = this.currentOrNull();
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

