/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.terremark.xml;

import java.util.Map;
import javax.inject.Inject;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.terremark.domain.TerremarkVDC;
import org.jclouds.vcloud.terremark.domain.internal.TerremarkVDCImpl;
import org.jclouds.vcloud.util.Utils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VDCHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TerremarkVDCHandler
extends VDCHandler {
    private ReferenceType catalog;
    private ReferenceType publicIps;
    private ReferenceType internetServices;

    @Inject
    public TerremarkVDCHandler(TaskHandler taskHandler) {
        super(taskHandler);
    }

    public TerremarkVDC getResult() {
        VDC vDC = super.getResult();
        return new TerremarkVDCImpl(vDC.getName(), vDC.getType(), vDC.getHref(), this.status, this.org, this.description, this.tasks, this.allocationModel, this.storageCapacity, this.cpuCapacity, this.memoryCapacity, this.resourceEntities, this.availableNetworks, this.nicQuota, this.networkQuota, this.vmQuota, this.isEnabled, this.catalog, this.publicIps, this.internetServices);
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Map attributes = Utils.cleanseAttributes((Attributes)attrs);
        super.startElement(uri, localName, qName, attrs);
        if (qName.equals("Link")) {
            String name = (String)attributes.get("name");
            if (name.equals("Internet Services")) {
                this.internetServices = Utils.newReferenceType((Map)attributes);
            } else if (name.equals("Public IPs")) {
                this.publicIps = Utils.newReferenceType((Map)attributes);
            } else {
                String type = (String)attributes.get("type");
                if (type.equals("application/vnd.vmware.vcloud.catalog+xml")) {
                    this.catalog = Utils.newReferenceType((Map)attributes);
                }
            }
        }
    }
}

