/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.commands;

import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.jclouds.chef.ChefService;
import org.jclouds.karaf.chef.commands.ChefCommandBase;
import org.jclouds.karaf.chef.core.ChefHelper;

public abstract class ChefCommandWithOptions
extends ChefCommandBase {
    @Option(name="--name", description="The service context name. Used to distinct between multiple service of the same provider/api. Only ")
    protected String name;
    @Option(name="--api", description="The api or use.")
    protected String api = "chef";
    @Option(name="--client-name", description="The name of the client.")
    protected String clientName;
    @Option(name="--client-key-file", description="The path to the client key file.")
    protected String clientKeyFile;
    @Option(name="--validator-name", description="The name of the validator.")
    protected String validatorName;
    @Option(name="--validator-key-file", description="The patht to the validator key file.")
    protected String validatorKeyFile;
    @Option(name="--endpoint", description="The endpoint to use for a chef service.")
    protected String endpoint;

    @Override
    public List<ChefService> getChefServices() {
        if (this.api == null) {
            return this.chefServices;
        }
        try {
            ChefService service = this.getChefService();
            return Collections.singletonList(service);
        }
        catch (Throwable t) {
            return Collections.emptyList();
        }
    }

    protected ChefService getChefService() {
        return ChefHelper.findOrCreateChefService(this.api, this.name, this.clientName, null, this.clientKeyFile, this.validatorName, null, this.validatorKeyFile, this.endpoint, this.chefServices);
    }
}

