/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.core;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.ChefService;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChefHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChefHelper.class);
    public static final String JCLOUDS_CHEF_API = "JCLOUDS_CHEF_API";
    public static final String JCLOUDS_CHEF_CLIENT_NAME = "JCLOUDS_CHEF_CLIENT_NAME";
    public static final String JCLOUDS_CHEF_CLIENT_KEY_FILE = "JCLOUDS_CHEF_CLIENT_KEY_FILE";
    public static final String JCLOUDS_CHEF_CLIENT_CREDENTIAL = "JCLOUDS_CHEF_CLIENT_CREDENTIAL";
    public static final String JCLOUDS_CHEF_VALIDATOR_NAME = "JCLOUDS_CHEF_VALIDATOR_NAME";
    public static final String JCLOUDS_CHEF_VALIDATOR_KEY_FILE = "JCLOUDS_CHEF_VALIDATOR_KEY_FILE";
    public static final String JCLOUDS_CHEF_VALIDATOR_CREDENTIAL = "JCLOUDS_CHEF_VALIDATOR_CREDENTIAL";
    public static final String JCLOUDS_CHEF_ENDPOINT = "JCLOUDS_CHEF_ENDPOINT";

    private ChefHelper() {
    }

    public static String getChefApi(String api) {
        if (api != null) {
            return api;
        }
        return System.getenv(JCLOUDS_CHEF_API);
    }

    public static String getClientName(String clientName) {
        if (clientName != null) {
            return clientName;
        }
        return System.getenv(JCLOUDS_CHEF_CLIENT_NAME);
    }

    public static String getClientCredential(String clientCredential) {
        if (clientCredential != null) {
            return clientCredential;
        }
        return System.getenv(JCLOUDS_CHEF_CLIENT_CREDENTIAL);
    }

    public static String getClientKeyFile(String clientKeyFile) {
        if (clientKeyFile != null) {
            return clientKeyFile;
        }
        return System.getenv(JCLOUDS_CHEF_CLIENT_KEY_FILE);
    }

    public static String getValidatorName(String validatorName) {
        if (validatorName != null) {
            return validatorName;
        }
        return System.getenv(JCLOUDS_CHEF_VALIDATOR_NAME);
    }

    public static String getValidatorCredential(String validatorCredential) {
        if (validatorCredential != null) {
            return validatorCredential;
        }
        return System.getenv(JCLOUDS_CHEF_VALIDATOR_CREDENTIAL);
    }

    public static String getValidatorKeyFile(String validatorKeyFile) {
        if (validatorKeyFile != null) {
            return validatorKeyFile;
        }
        return System.getenv(JCLOUDS_CHEF_VALIDATOR_KEY_FILE);
    }

    public static String getChefEndpoint(String endpoint) {
        if (endpoint != null) {
            return endpoint;
        }
        return System.getenv(JCLOUDS_CHEF_ENDPOINT);
    }

    public static ChefService getChefService(String id, String api, List<ChefService> services) {
        if (!Strings.isNullOrEmpty((String)id)) {
            ChefService service = null;
            for (ChefService svc : services) {
                if (!id.equals(svc.getContext().getName())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("No chef service with id" + id + " found.");
            }
            return service;
        }
        if (!Strings.isNullOrEmpty((String)api)) {
            ChefService service = null;
            for (ChefService svc : services) {
                if (!api.equals(svc.getContext().getId())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("No Api named " + api + " found.");
            }
            return service;
        }
        if (services.size() == 0) {
            throw new IllegalArgumentException("No apis are present.  Note: It takes a couple of seconds for the provider to initialize.");
        }
        if (services.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (ChefService svc : services) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(svc.getContext().getId());
            }
            throw new IllegalArgumentException("Multiple apis are present, please select one using the--api argument in the following values: " + sb.toString());
        }
        return services.get(0);
    }

    public static ChefService createChefServiceFromEnvironment() {
        return ChefHelper.findOrCreateChefService(null, null, null, null, null, null, null, null, null, Lists.newArrayList());
    }

    public static ChefService findOrCreateChefService(String api, String name, String clientName, String clientCredential, String clientKeyFile, String validatorName, String validatorCredential, String validatorKeyFile, String endpoint, List<ChefService> chefServices) {
        boolean canCreateService;
        String endpointValue;
        String validatorKeyFileValue;
        String validatorCredentialValue;
        String validatorNameValue;
        String clientKeyFileValue;
        String clientCredentialValue;
        String clientNameValue;
        String apiValue;
        ChefService chefService;
        block12: {
            if (name == null && api == null && chefServices != null && chefServices.size() == 1) {
                return chefServices.get(0);
            }
            chefService = null;
            apiValue = ChefHelper.getChefApi(api);
            clientNameValue = ChefHelper.getClientName(clientName);
            clientCredentialValue = ChefHelper.getClientCredential(clientCredential);
            clientKeyFileValue = ChefHelper.getClientKeyFile(clientKeyFile);
            validatorNameValue = ChefHelper.getValidatorName(validatorName);
            validatorCredentialValue = ChefHelper.getValidatorCredential(validatorCredential);
            validatorKeyFileValue = ChefHelper.getValidatorKeyFile(validatorKeyFile);
            endpointValue = ChefHelper.getChefEndpoint(endpoint);
            boolean contextNameProvided = !Strings.isNullOrEmpty((String)name);
            canCreateService = (!Strings.isNullOrEmpty((String)clientNameValue) || !Strings.isNullOrEmpty((String)clientKeyFileValue)) && !Strings.isNullOrEmpty((String)validatorNameValue) && !Strings.isNullOrEmpty((String)validatorKeyFileValue);
            apiValue = !Strings.isNullOrEmpty((String)apiValue) ? apiValue : "chef";
            name = !Strings.isNullOrEmpty((String)name) ? name : apiValue;
            try {
                chefService = ChefHelper.getChefService(name, apiValue, chefServices);
            }
            catch (Throwable t) {
                if (contextNameProvided) {
                    throw new RuntimeException("Could not find chef service with id:" + name);
                }
                if (canCreateService) break block12;
                StringBuilder sb = new StringBuilder();
                sb.append("Insufficient information to create chef service:").append("\n");
                if (apiValue == null) {
                    sb.append("Missing provider or api. Please specify either using the --api options, or the JCLOUDS_CHEF_API  environmental variables.").append("\n");
                }
                if (clientNameValue == null) {
                    sb.append("Missing client name. Please specify either using the --client-name option, or the JCLOUDS_CHEF_CLIENT_NAME environmental variable.").append("\n");
                }
                if (clientKeyFileValue == null) {
                    sb.append("Missing client credential. Please specify either using the --client-key-file option, or the JCLOUDS_CHEF_CLIENT_KEY_FILE environmental variable.").append("\n");
                }
                if (validatorName == null) {
                    sb.append("Missing validator name. Please specify either using the --validator-name option, or the JCLOUDS_CHEF_VALIDATOR_NAME environmental variable.").append("\n");
                }
                if (validatorKeyFile == null) {
                    sb.append("Missing validator credential. Please specify either using the --validator-key-file option, or the JCLOUDS_CHEF_VALIDATOR_KEY_FILE environmental variable.").append("\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
        if (chefService == null && canCreateService) {
            try {
                chefService = ChefHelper.createChefService(Apis.withId((String)apiValue), name, clientNameValue, clientCredentialValue, clientKeyFileValue, validatorNameValue, validatorCredentialValue, validatorKeyFileValue, endpointValue);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create service:" + ex.getMessage());
            }
        }
        return chefService;
    }

    public static ChefService createChefService(ApiMetadata apiMetadata, String name, String clientName, String clientCredential, String clientKeyFile, String validatorName, String validatorCredential, String validatorKeyFile, String endpoint) throws Exception {
        if (Strings.isNullOrEmpty((String)clientName) && apiMetadata != null && !apiMetadata.getDefaultCredential().isPresent()) {
            LOGGER.warn("No client specified for api {}.", (Object)apiMetadata.getId());
            return null;
        }
        if (Strings.isNullOrEmpty((String)validatorName) && apiMetadata != null && !apiMetadata.getDefaultCredential().isPresent()) {
            LOGGER.warn("No validator name specified for api {}.", (Object)apiMetadata.getId());
            return null;
        }
        if (Strings.isNullOrEmpty((String)validatorCredential) && !Strings.isNullOrEmpty((String)validatorKeyFile)) {
            validatorCredential = ChefHelper.credentialsFromPath(validatorKeyFile);
        }
        if (Strings.isNullOrEmpty((String)clientCredential) && !Strings.isNullOrEmpty((String)clientKeyFile)) {
            clientCredential = ChefHelper.credentialsFromPath(clientKeyFile);
        } else if (Strings.isNullOrEmpty((String)clientCredential)) {
            clientCredential = ChefHelper.credentialForClient(clientName);
        }
        Properties chefConfig = new Properties();
        chefConfig.put("chef.validator-name", validatorName);
        chefConfig.put("chef.validator-credential", validatorCredential);
        ContextBuilder builder = null;
        if (apiMetadata != null) {
            builder = ContextBuilder.newBuilder((ApiMetadata)apiMetadata).overrides(chefConfig);
        }
        if (!Strings.isNullOrEmpty((String)endpoint)) {
            builder = builder.endpoint(endpoint);
        }
        builder = builder.name(name).modules((Iterable)ImmutableSet.of((Object)new SLF4JLoggingModule()));
        builder = builder.name(name).credentials(clientName, clientCredential).overrides(chefConfig);
        ChefContext context = (ChefContext)builder.build();
        ChefService service = context.getChefService();
        return service;
    }

    public static String credentialForClient(String client) throws Exception {
        String pemFile = System.getProperty("user.home") + "/.chef/" + client + ".pem";
        return Files.toString((File)new File(pemFile), (Charset)Charsets.UTF_8);
    }

    public static String credentialsFromPath(String path) throws Exception {
        return Files.toString((File)new File(path), (Charset)Charsets.UTF_8);
    }
}

