/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.AbstractAction;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.chef.ChefService;
import org.jclouds.chef.domain.CookbookVersion;
import org.jclouds.karaf.cache.BasicCacheProvider;
import org.jclouds.karaf.cache.CacheProvider;
import org.jclouds.karaf.commands.table.ShellTable;
import org.jclouds.karaf.commands.table.ShellTableFactory;
import org.jclouds.karaf.commands.table.internal.PropertyShellTableFactory;
import org.jclouds.karaf.utils.ServiceHelper;
import org.jclouds.rest.AuthorizationException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ChefCommandBase
extends AbstractAction {
    public static final String PROVIDERFORMAT = "%-24s %-12s %-12s";
    public static final String FACTORY_FILTER = "(service.factoryPid=%s)";
    protected ConfigurationAdmin configAdmin;
    protected CacheProvider cacheProvider = new BasicCacheProvider();
    protected List<ChefService> chefServices = new ArrayList<ChefService>();
    protected ShellTableFactory shellTableFactory = new PropertyShellTableFactory();

    public Object execute(CommandSession session) throws Exception {
        try {
            this.session = session;
            return this.doExecute();
        }
        catch (AuthorizationException ex) {
            System.err.println("Authorization error. Please make sure you provided valid identity and credential.");
            return null;
        }
    }

    protected void printChefApis(Iterable<ApiMetadata> apis, List<ChefService> chefServices, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]", "[service]"));
        for (ApiMetadata api : apis) {
            StringBuilder sb = new StringBuilder();
            sb.append("[ ");
            for (ChefService chefService : chefServices) {
                String contextName = chefService.getContext().getName();
                if (!chefService.getContext().getId().equals(api.getId()) || contextName == null) continue;
                sb.append(contextName).append(" ");
            }
            sb.append("]");
            out.println(String.format(PROVIDERFORMAT, api.getId(), "chef", sb.toString()));
        }
    }

    protected void printCookbooks(ChefService service, Iterable<? extends CookbookVersion> cookbookVersions, PrintStream out) {
        ShellTable table = this.shellTableFactory.build("cookbook");
        table.setDisplayData(cookbookVersions);
        table.display(out, true, true);
        for (CookbookVersion cookbookVersion : cookbookVersions) {
            for (String cacheKey : ServiceHelper.findCacheKeysForService(service)) {
                this.cacheProvider.getProviderCacheForType("COOKBOOK_CACHE").putAll((Object)cacheKey, cookbookVersion.getMetadata().getProviding().keySet());
            }
        }
    }

    protected Configuration findOrCreateFactoryConfiguration(ConfigurationAdmin configurationAdmin, String factoryPid, String id, String api) throws IOException {
        Configuration configuration = null;
        if (configurationAdmin != null) {
            try {
                Configuration[] configurations = configurationAdmin.listConfigurations(String.format(FACTORY_FILTER, factoryPid));
                if (configurations != null) {
                    for (Configuration conf : configurations) {
                        Dictionary dictionary = conf.getProperties();
                        if (!(dictionary != null && id != null ? id.equals(dictionary.get("name")) : dictionary != null && api != null && api.equals(dictionary.get("api")))) continue;
                        return conf;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            configuration = configurationAdmin.createFactoryConfiguration(factoryPid, null);
        }
        return configuration;
    }

    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public List<ChefService> getChefServices() {
        return this.chefServices;
    }

    public void setChefServices(List<ChefService> chefServices) {
        this.chefServices = chefServices;
    }

    public ShellTableFactory getShellTableFactory() {
        return this.shellTableFactory;
    }

    public void setShellTableFactory(ShellTableFactory shellTableFactory) {
        this.shellTableFactory = shellTableFactory;
    }
}

