/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.commands;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.karaf.chef.commands.ChefCommandBase;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(scope="chef", name="service-destroy", description="Destroys a chef service")
public class ChefServiceDestroyCommand
extends ChefCommandBase {
    @Argument(index=0, required=true, multiValued=false, description="The service id. Used to distinct between multiple service of the same provider/api. Only ")
    protected String id;

    protected Object doExecute() throws Exception {
        Configuration configuration = this.findOrCreateFactoryConfiguration(this.configAdmin, "org.jclouds.chef", this.id, null);
        if (configuration != null) {
            configuration.delete();
        } else {
            System.out.println("No service found with id " + this.id);
        }
        return null;
    }

    @Override
    public ConfigurationAdmin getConfigAdmin() {
        return this.configAdmin;
    }

    @Override
    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }
}

