/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.chef.commands.completer;

import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.apis.Apis;
import org.jclouds.chef.ChefContext;
import org.jclouds.chef.ChefService;

public class ChefApiCompleter
implements Completer {
    private final StringsCompleter delegate = new StringsCompleter();
    private List<? extends ChefService> chefServices;
    private final boolean displayApisWithoutService;

    public ChefApiCompleter(boolean displayApisWithoutService) {
        this.displayApisWithoutService = displayApisWithoutService;
    }

    public int complete(String buffer, int cursor, List<String> candidates) {
        try {
            if (this.displayApisWithoutService) {
                for (ApiMetadata apiMetadata : Apis.contextAssignableFrom((TypeToken)TypeToken.of(ChefContext.class))) {
                    this.delegate.getStrings().add(apiMetadata.getId());
                }
            } else if (this.chefServices != null) {
                for (ChefService chefService : this.chefServices) {
                    String id = chefService.getContext().unwrap().getId();
                    if (Apis.withId((String)id) == null) continue;
                    this.delegate.getStrings().add(id);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return this.delegate.complete(buffer, cursor, candidates);
    }

    public List<? extends ChefService> getChefServices() {
        return this.chefServices;
    }

    public void setChefServices(List<? extends ChefService> chefServices) {
        this.chefServices = chefServices;
    }
}

