/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStoreCommandSupport
extends OsgiCommandSupport {
    private static final Logger logger = LoggerFactory.getLogger(BlobStoreCommandSupport.class);
    private List<BlobStore> services;
    @Option(name="--provider")
    protected String provider;

    public void setBlobStoreServices(List<BlobStore> services) {
        this.services = services;
    }

    protected List<BlobStore> getBlobStoreServices() {
        if (this.provider == null) {
            return this.services;
        }
        return Collections.singletonList(this.getBlobStore());
    }

    protected BlobStore getBlobStore() {
        if (this.provider != null) {
            BlobStore service = null;
            for (BlobStore svc : this.services) {
                if (!this.provider.equals(service.getContext().getProviderSpecificContext().getId())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("Provider " + this.provider + " not found");
            }
            return service;
        }
        if (this.services.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (BlobStore svc : this.services) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(svc.getContext().getProviderSpecificContext().getId());
            }
            throw new IllegalArgumentException("Multiple providers are present, please select one using the --provider argument in the following values: " + sb.toString());
        }
        return this.services.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(String bucket, String blobName) {
        Object result = null;
        ObjectInputStream ois = null;
        BlobStore blobStore = this.getBlobStore();
        blobStore.createContainerInLocation(null, bucket);
        InputStream is = blobStore.getBlob(bucket, blobName).getPayload().getInput();
        try {
            ois = new ObjectInputStream(is);
            result = ois.readObject();
        }
        catch (IOException e) {
            logger.error("Error reading object.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error("Error reading object.", (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String bucket, String blobName, Object object) {
        BlobStore blobStore = this.getBlobStore();
        Blob blob = blobStore.blobBuilder(blobName).build();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            blob.setPayload(baos.toByteArray());
            blobStore.putBlob(bucket, blob);
        }
        catch (IOException e) {
            logger.error("Error while writing blob", (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

