/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.util.Collections;
import java.util.List;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.jclouds.compute.ComputeService;

public abstract class ComputeCommandSupport
extends OsgiCommandSupport {
    private List<ComputeService> services;
    @Option(name="--provider")
    protected String provider;

    public void setServices(List<ComputeService> services) {
        this.services = services;
    }

    protected List<ComputeService> getComputeServices() {
        if (this.provider == null) {
            return this.services;
        }
        return Collections.singletonList(this.getComputeService());
    }

    protected ComputeService getComputeService() {
        if (this.provider != null) {
            ComputeService service = null;
            for (ComputeService svc : this.services) {
                if (!this.provider.equals(service.getContext().getProviderSpecificContext().getId())) continue;
                service = svc;
                break;
            }
            if (service == null) {
                throw new IllegalArgumentException("Provider " + this.provider + " not found");
            }
            return service;
        }
        if (this.services.size() != 1) {
            StringBuilder sb = new StringBuilder();
            for (ComputeService svc : this.services) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(svc.getContext().getProviderSpecificContext().getId());
            }
            throw new IllegalArgumentException("Multiple providers are present, please select one using the --provider argument in the following values: " + sb.toString());
        }
        return this.services.get(0);
    }
}

