/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.domain.Location;
import org.jclouds.karaf.commands.compute.ComputeCommandSupport;

@Command(scope="jclouds", name="list")
public class ListCommand
extends ComputeCommandSupport {
    protected Object doExecute() throws Exception {
        for (ComputeService service : this.getComputeServices()) {
            String txt = "Instances on " + service.getContext().getProviderSpecificContext().getId();
            System.out.println(txt);
            for (int i = 0; i < txt.length(); ++i) {
                System.out.print('=');
            }
            System.out.println();
            System.out.println("  Locations");
            System.out.println("  ---------");
            this.printLocations(service.listAssignableLocations(), "    ", System.out);
            System.out.println("  Images");
            System.out.println("  ------");
            this.printImages(service.listImages(), "    ", System.out);
            System.out.println("  Hardware");
            System.out.println("  --------");
            this.printHardwares(service.listHardwareProfiles(), "    ", System.out);
            System.out.println("  Nodes");
            System.out.println("  -----");
            this.printNodes(service.listNodes(), "    ", System.out);
        }
        return null;
    }

    private void printNodes(Set<? extends ComputeMetadata> nodes, String indent, PrintStream out) {
        out.println(String.format("%s%-30s %-20s %-20s %-20s", indent, "[id]", "[location]", "[hardware]", "[state]"));
        for (ComputeMetadata computeMetadata : nodes) {
            NodeMetadata node = (NodeMetadata)computeMetadata;
            out.println(String.format("%s%-30s %-20s %-20s %-20s", indent, node.getId(), node.getLocation().getId(), node.getHardware().getId(), node.getState().toString().toLowerCase()));
        }
    }

    private void printHardwares(Set<? extends Hardware> hardwares, String indent, PrintStream out) {
        out.println(String.format("%s%-20s %5s %7s %6s", indent, "[id]", "[cpu]", "[cores]", "[ram]", "[disk]"));
        for (Hardware hardware : hardwares) {
            out.println(String.format("%s%-20s %5.1f %7.1f %6.0f", indent, hardware.getId(), this.getCpuUnits(hardware), this.getCpuCores(hardware), this.getMemory(hardware)));
        }
    }

    private double getMemory(Hardware hardware) {
        return hardware.getRam();
    }

    private double getCpuCores(Hardware hardware) {
        int nb = 0;
        for (Processor p : hardware.getProcessors()) {
            nb = (int)((double)nb + p.getCores());
        }
        return nb;
    }

    private double getCpuUnits(Hardware hardware) {
        double nb = 0.0;
        for (Processor p : hardware.getProcessors()) {
            nb += p.getCores() * p.getSpeed();
        }
        return nb;
    }

    private void printImages(Set<? extends Image> images, String indent, PrintStream out) {
        out.println(String.format("%s%-30s %-20s %s", indent, "[id]", "[location]", "[description]"));
        for (Image image : images) {
            out.println(String.format("%s%-30s %-20s %s", indent, image.getId(), image.getLocation().getId(), image.getDescription()));
        }
    }

    private void printLocations(Set<? extends Location> locations, String indent, PrintStream out) {
        out.println(String.format("%-30s %-9s %s", indent + "[id]", "[scope]", "[description]"));
        this.printLocations(this.getAllLocations(locations), null, indent, out);
    }

    private void printLocations(Set<? extends Location> locations, Location parent, String indent, PrintStream out) {
        for (Location location : locations) {
            if (location.getParent() != parent) continue;
            out.println(String.format("%-30s %-9s %s", indent + location.getId(), location.getScope(), location.getDescription()));
            this.printLocations(locations, location, indent + "  ", out);
        }
    }

    private Set<? extends Location> getAllLocations(Set<? extends Location> locations) {
        HashSet<Location> all = new HashSet<Location>();
        Iterator<? extends Location> i$ = locations.iterator();
        while (i$.hasNext()) {
            Location loc;
            for (Location p = loc = i$.next(); p != null; p = p.getParent()) {
                all.add(p);
            }
        }
        return all;
    }
}

