/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.io.File;
import java.io.FileOutputStream;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.jclouds.karaf.commands.blobstore.BlobStoreCommandSupport;

@Command(scope="jclouds", name="blobstore-read", description="Reads data from the blobstore")
public class BlobReadCommand
extends BlobStoreCommandSupport {
    @Argument(index=0, name="containerName", description="The name of the container", required=true, multiValued=false)
    String containerName;
    @Argument(index=1, name="blobName", description="The name of the blob", required=true, multiValued=false)
    String blobName;
    @Argument(index=2, name="file", description="The file to store the blob", required=false, multiValued=false)
    String file;

    protected Object doExecute() throws Exception {
        if (this.file == null) {
            Object payload = this.read(this.containerName, this.blobName);
            System.out.printf("%s\n", payload);
        } else {
            File f = new File(this.file);
            if (!f.exists() && f.createNewFile()) {
                this.copy(this.getBlobInputStream(this.containerName, this.blobName), new FileOutputStream(f));
            }
        }
        return null;
    }
}

