/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.blobstore;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.karaf.utils.blobstore.BlobStoreHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobStoreCommandSupport
extends OsgiCommandSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreCommandSupport.class);
    private static final int SIZE = 32768;
    public static final String PROVIDERFORMAT = "%-16s %s";
    private List<BlobStore> services;
    private Set<String> containerCache;
    private Set<String> blobCache;
    @Option(name="--provider")
    protected String provider;

    public void setBlobStoreServices(List<BlobStore> services) {
        this.services = services;
    }

    protected List<BlobStore> getBlobStoreServices() {
        if (this.provider == null) {
            return this.services;
        }
        return Collections.singletonList(this.getBlobStore());
    }

    protected BlobStore getBlobStore() {
        return BlobStoreHelper.getBlobStore(this.provider, this.services);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object read(String containerName, String blobName) {
        Object result = null;
        ObjectInputStream ois = null;
        BlobStore blobStore = this.getBlobStore();
        blobStore.createContainerInLocation(null, containerName);
        InputStream is = blobStore.getBlob(containerName, blobName).getPayload().getInput();
        try {
            ois = new ObjectInputStream(is);
            result = ois.readObject();
        }
        catch (IOException e) {
            LOGGER.error("Error reading object.", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error reading object.", (Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public InputStream getBlobInputStream(String containerName, String blobName) {
        return this.getBlobStore().getBlob(containerName, blobName).getPayload().getInput();
    }

    public void write(String containerName, String blobName, Object object) {
        BlobStore blobStore = this.getBlobStore();
        Blob blob = blobStore.blobBuilder(blobName).build();
        blob.setPayload(this.toBytes(object));
        blobStore.putBlob(containerName, blob);
    }

    public void write(String bucket, String blobName, InputStream is) {
        BlobStore blobStore = this.getBlobStore();
        Blob blob = blobStore.blobBuilder(blobName).build();
        blob.setPayload(is);
        blobStore.putBlob(bucket, blob);
        try {
            is.close();
        }
        catch (Exception ex) {
            LOGGER.warn("Error closing input stream.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes(Object object) {
        byte[] result = null;
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(object);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Error while writing blob", (Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromUrl(URL url) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(url.openStream());
            int size = 0;
            while ((size = dis.available()) > 0) {
                byte[] buffer = new byte[size];
                baos.write(buffer);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            LOGGER.warn("Failed to read from stream.", (Throwable)e);
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (Exception e) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception e) {}
            }
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(InputStream is, OutputStream os) {
        byte[] buffer = new byte[32768];
        int read = 0;
        try {
            read = is.read(buffer);
            while (read >= 0) {
                if (read > 0) {
                    os.write(buffer, 0, read);
                }
                read = is.read(buffer);
            }
        }
        catch (IOException e) {
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception ex) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void printBlobStoreProviders(List<BlobStore> blobStores, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]"));
        for (BlobStore blobStore : blobStores) {
            out.println(String.format(PROVIDERFORMAT, blobStore.getContext().getProviderSpecificContext().getId(), "blob"));
        }
    }

    public Set<String> getContainerCache() {
        return this.containerCache;
    }

    public void setContainerCache(Set<String> containerCache) {
        this.containerCache = containerCache;
    }

    public Set<String> getBlobCache() {
        return this.blobCache;
    }

    public void setBlobCache(Set<String> blobCache) {
        this.blobCache = blobCache;
    }
}

