/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.cache;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jclouds.karaf.commands.cache.Cacheable;

public class CacheManager<T>
implements Runnable {
    private ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private List<? extends Cacheable<T>> cacheables;

    public void init() {
        this.scheduledExecutorService.scheduleAtFixedRate(this, 0L, 5L, TimeUnit.MINUTES);
    }

    public void destroy() {
        this.scheduledExecutorService.shutdown();
    }

    @Override
    public void run() {
        if (this.cacheables != null && !this.cacheables.isEmpty()) {
            for (Cacheable<T> cacheable : this.cacheables) {
                cacheable.updateCache();
            }
        }
    }

    public void bind(T service) {
        this.scheduledExecutorService.submit(this);
    }

    public void unbind(T service) {
    }

    public List<? extends Cacheable<T>> getCacheables() {
        return this.cacheables;
    }

    public void setCacheables(List<? extends Cacheable<T>> cacheables) {
        this.cacheables = cacheables;
    }
}

