/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.karaf.commands.compute;

import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.domain.Location;
import org.jclouds.karaf.commands.cache.CacheProvider;
import org.jclouds.karaf.utils.compute.ComputeHelper;
import org.osgi.service.cm.ConfigurationAdmin;

public abstract class ComputeCommandSupport
extends OsgiCommandSupport {
    public static final String NODEFORMAT = "%s%-30s %-32s %-20s %-12s %-12s";
    public static final String HARDWAREFORMAT = "%s%-20s %5s %7s %6s";
    public static final String IMAGEFORMAT = "%s%-30s %-32s %s";
    public static final String LOCATIONFORMAT = "%-32s %-9s %s";
    public static final String PROVIDERFORMAT = "%-16s %s";
    private ConfigurationAdmin configurationAdmin;
    private List<ComputeService> computeServices;
    @Option(name="--provider")
    protected String provider;

    protected void printComputeProviders(List<ComputeService> computeServices, String indent, PrintStream out) {
        out.println(String.format(PROVIDERFORMAT, "[id]", "[type]"));
        for (ComputeService computeService : computeServices) {
            out.println(String.format(PROVIDERFORMAT, computeService.getContext().getProviderSpecificContext().getId(), "compute"));
        }
    }

    protected void printNodes(Set<? extends ComputeMetadata> nodes, String indent, PrintStream out) {
        out.println(String.format(NODEFORMAT, indent, "[id]", "[location]", "[hardware]", "[group]", "[state]"));
        for (ComputeMetadata computeMetadata : nodes) {
            NodeMetadata node = (NodeMetadata)computeMetadata;
            out.println(String.format(NODEFORMAT, indent, node.getId(), node.getLocation().getId(), node.getHardware().getId(), node.getGroup(), node.getState().toString().toLowerCase()));
            CacheProvider.getCache("node").add(node.getId());
            CacheProvider.getCache("group").add(node.getGroup());
        }
    }

    protected void printHardwares(Set<? extends Hardware> hardwares, String indent, PrintStream out) {
        out.println(String.format(HARDWAREFORMAT, indent, "[id]", "[cpu]", "[cores]", "[ram]", "[disk]"));
        for (Hardware hardware : hardwares) {
            out.println(String.format(HARDWAREFORMAT, indent, hardware.getId(), this.getCpuUnits(hardware), this.getCpuCores(hardware), this.getMemory(hardware)));
        }
    }

    protected void printImages(Set<? extends Image> images, String indent, PrintStream out) {
        out.println(String.format(IMAGEFORMAT, indent, "[id]", "[location]", "[description]"));
        for (Image image : images) {
            String id = image.getId();
            String location = image.getLocation() != null ? image.getLocation().getId() : "";
            String description = image.getDescription();
            out.println(String.format(IMAGEFORMAT, indent, id, location, description));
            CacheProvider.getCache("image").add(image.getId());
        }
    }

    protected void printLocations(Set<? extends Location> locations, String indent, PrintStream out) {
        out.println(String.format(LOCATIONFORMAT, indent + "[id]", "[scope]", "[description]"));
        this.printLocations(this.getAllLocations(locations), null, indent, out);
    }

    protected void printLocations(Set<? extends Location> locations, Location parent, String indent, PrintStream out) {
        for (Location location : locations) {
            if (location.getParent() != parent) continue;
            out.println(String.format(LOCATIONFORMAT, indent + location.getId(), location.getScope(), location.getDescription()));
            this.printLocations(locations, location, indent + "  ", out);
        }
    }

    protected Set<? extends Location> getAllLocations(Set<? extends Location> locations) {
        HashSet<Location> all = new HashSet<Location>();
        Iterator<? extends Location> i$ = locations.iterator();
        while (i$.hasNext()) {
            Location loc;
            for (Location p = loc = i$.next(); p != null; p = p.getParent()) {
                all.add(p);
                CacheProvider.getCache("location").add(p.getId());
            }
        }
        return all;
    }

    protected double getMemory(Hardware hardware) {
        return hardware.getRam();
    }

    protected double getCpuCores(Hardware hardware) {
        int nb = 0;
        for (Processor p : hardware.getProcessors()) {
            nb = (int)((double)nb + p.getCores());
        }
        return nb;
    }

    protected double getCpuUnits(Hardware hardware) {
        double nb = 0.0;
        for (Processor p : hardware.getProcessors()) {
            nb += p.getCores() * p.getSpeed();
        }
        return nb;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setComputeServices(List<ComputeService> computeServices) {
        this.computeServices = computeServices;
    }

    protected List<ComputeService> getComputeServices() {
        if (this.provider == null) {
            return this.computeServices;
        }
        return Collections.singletonList(this.getComputeService());
    }

    protected ComputeService getComputeService() {
        return ComputeHelper.getComputeService(this.provider, this.computeServices);
    }
}

